% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_objects.R
\name{tar_objects}
\alias{tar_objects}
\title{List saved targets}
\usage{
tar_objects(
  names = NULL,
  cloud = TRUE,
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{names}{Optional \code{tidyselect} selector such as
\code{\link[=any_of]{any_of()}} or \code{\link[=starts_with]{starts_with()}} to return
a tactical subset of target names.
If \code{NULL}, all names are selected.}

\item{cloud}{Logical of length 1, whether to include
cloud targets in the output
(e.g. \code{tar_target(..., repository = "aws")}).}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
Character vector of targets saved to \verb{_targets/objects/}.
}
\description{
List targets currently saved to \verb{_targets/objects/}
or the cloud. Does not include local files
with \code{tar_target(..., format = "file", repository = "local")}.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
  list(tar_target(x, "value"))
}, ask = FALSE)
tar_make()
tar_objects()
tar_objects(starts_with("x")) # see also any_of()
})
}
}
\seealso{
Other data: 
\code{\link{tar_crew}()},
\code{\link{tar_load_everything}()},
\code{\link{tar_load_raw}()},
\code{\link{tar_load}()},
\code{\link{tar_meta}()},
\code{\link{tar_pid}()},
\code{\link{tar_process}()},
\code{\link{tar_read_raw}()},
\code{\link{tar_read}()}
}
\concept{data}
