% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_seed.R
\name{tar_seed}
\alias{tar_seed}
\title{Get the random number generator seed of the target currently running.}
\usage{
tar_seed(default = 1L)
}
\arguments{
\item{default}{Integer, value to return if \code{tar_seed()}
is called on its own outside a \code{targets} pipeline.
Having a default lets users run things without \code{\link[=tar_make]{tar_make()}},
which helps peel back layers of code and troubleshoot bugs.}
}
\value{
Integer of length 1. If invoked inside a \code{targets} pipeline,
the return value is the seed of the target currently running,
which is a deterministic function of the target name. Otherwise,
the return value is \code{default}.
}
\description{
Get the random number generator seed
of the target currently running.
}
\details{
A target's random number generator seed
is a deterministic function of its name. In this way,
each target runs with a reproducible seed so someone else
running the same pipeline should get the same results,
and no two targets in the same pipeline share the same seed.
(Even dynamic branches have different names and thus different seeds.)
You can retrieve the seed of a completed target
with \code{tar_meta(your_target, seed)}
and run \code{set.seed()} on the result to locally
recreate the target's initial RNG state.
}
\examples{
tar_seed()
tar_seed(default = 123L)
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script(tar_target(returns_seed, tar_seed()), ask = FALSE)
tar_make()
tar_read(returns_seed)
})
}
}
\seealso{
Other utilities: 
\code{\link{tar_cancel}()},
\code{\link{tar_definition}()},
\code{\link{tar_envir}()},
\code{\link{tar_group}()},
\code{\link{tar_name}()},
\code{\link{tar_path}()}
}
\concept{utilities}
