% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_outdated.R
\name{tar_outdated}
\alias{tar_outdated}
\title{Check which targets are outdated.}
\usage{
tar_outdated(
  names = NULL,
  branches = FALSE,
  targets_only = TRUE,
  reporter = "silent",
  callr_function = callr::r,
  callr_arguments = targets::callr_args_default(callr_function, reporter)
)
}
\arguments{
\item{names}{Names of the targets. \code{tar_outdated()} will check
these targets and all upstream ancestors in the dependency graph.
Set \code{names} to \code{NULL} to check/build all the targets (default).
Otherwise, you can supply symbols, a character vector,
or \code{tidyselect} helpers like \code{\link[=starts_with]{starts_with()}}.}

\item{branches}{Logical, whether to include branch names.
Including branches could get cumbersome for large pipelines.
Individual branch names are still omitted when branch-specific information
is not reliable: for example, when a pattern branches over
an outdated target.}

\item{targets_only}{Logical, whether to just restrict to targets
or to include functions and other global objects from the environment
created by running \verb{_targets.R}.}

\item{reporter}{Character of length 1, name of the reporter to user.
Controls how messages are printed as targets are checked. Choices:
\itemize{
\item \code{"silent"}: print nothing.
\item \code{"forecast"}: print running totals of the checked and outdated
targets found so far.
}}

\item{callr_function}{A function from \code{callr} to start a fresh clean R
process to do the work. Set to \code{NULL} to run in the current session
instead of an external process (but restart your R session just before
you do in order to clear debris out of the global environment).
\code{callr_function} needs to be \code{NULL} for interactive debugging,
e.g. \code{tar_option_set(debug = "your_target")}.
However, \code{callr_function} should not be \code{NULL} for serious
reproducible work.}

\item{callr_arguments}{A list of arguments to \code{callr_function}.}
}
\value{
Names of the outdated targets.
}
\description{
Checks for outdated targets in the pipeline,
targets that will be rerun automatically if you call
\code{\link[=tar_make]{tar_make()}} or similar. See \code{\link[=tar_cue]{tar_cue()}} for the rules
that decide whether a target needs to rerun.
}
\details{
Requires that you define a pipeline
with a \verb{_targets.R} script in your working directory.
(See \code{\link[=tar_script]{tar_script()}} for details.)
}
\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script(list(tar_target(x, 1 + 1)))
tar_outdated()
tar_script({
  list(
    tar_target(y1, 1 + 1),
    tar_target(y2, 1 + 1),
    tar_target(z, y1 + y2)
  )
}, ask = FALSE)
tar_outdated()
})
}
}
