% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intsurv.R
\name{int_surv}
\alias{int_surv}
\title{Integral approximation of a time dependent function.
Computes an approximation of \eqn{\int_start^stop S(t) dt}, where
\eqn{S(t)} is a survival function, for a selection of start and stop time
points.}
\usage{
int_surv(times, surv, start = 0, stop = max(times), extend = FALSE)
}
\arguments{
\item{times}{Numeric vector, sorted time points.}

\item{surv}{Numeric vector, values of a survival function evaluated at time
points given by \code{times}.}

\item{start}{Numeric vector, start of the integral.}

\item{stop}{Numeric vector, end of the integral.}

\item{extend}{(logical) If TRUE, integral is extended beyond the last
observed time point}
}
\value{
Numeric vector, value of the integral.
}
\description{
Integral approximation of a time dependent function.
Computes an approximation of \eqn{\int_start^stop S(t) dt}, where
\eqn{S(t)} is a survival function, for a selection of start and stop time
points.
}
\author{
Andreas Nordland
}
