% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_rep_raw.R
\name{tar_rep_run}
\alias{tar_rep_run}
\title{Run a batch in a \code{tar_rep()} archetype.}
\usage{
tar_rep_run(command, batch, reps, iteration, rep_workers)
}
\arguments{
\item{command}{Expression object, command to replicate.}

\item{batch}{Numeric of length 1, batch index.}

\item{reps}{Numeric of length 1, number of reps per batch.}

\item{iteration}{Character, iteration method.}

\item{rep_workers}{Positive integer of length 1, number of local R
processes to use to run reps within batches in parallel. If 1,
then reps are run sequentially within each batch. If greater than 1,
then reps within batch are run in parallel using workers
created with \code{future::plan(future.callr::callr, workers = rep_workers)}
and invoked with \code{furrr::future_map()}.}
}
\value{
Aggregated results of multiple executions of the
user-defined command supplied to \code{\link[=tar_rep]{tar_rep()}}. Depends on what
the user specifies. Common use cases are simulated datasets.
}
\description{
Internal function needed for \code{tar_rep()}.
Users should not invoke it directly.
}
\keyword{internal}
