% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ternaryplot.R
\name{ternaryplot}
\alias{ternaryplot}
\alias{ternaryplot.formula}
\alias{ternaryplot.data.frame}
\alias{ternaryplot.matrix}
\title{Ternary Plot}
\usage{
ternaryplot(x, data, ...)

\method{ternaryplot}{formula}(x, data = NULL, response = NULL,
  groups = NULL, density = FALSE, region = density || !is.null(response),
  contour = density || !is.null(response), labels = !is.null(response),
  colorkey = region, xlab, ylab, zlab, xlim = c(-0.15, 1.15),
  ylim = c(-0.3, 1), panel = panel.ternaryplot,
  default.prepanel = lattice.getOption("prepanel.default.xyplot"),
  drop.unused.levels = lattice.getOption("drop.unused.levels"),
  subset = TRUE, ...)

\method{ternaryplot}{data.frame}(x, data = NULL, ...)

\method{ternaryplot}{matrix}(x, data = NULL, ...)
}
\arguments{
\item{x}{See \strong{Methods (by class)}.}

\item{data}{A data frame in which the \code{formula}, \code{groups}, and conditioning
variables are evaluated.}

\item{...}{Arguments that are passed on to other methods, particularly
\code{\link[=panel.ternaryplot]{panel.ternaryplot()}}.}

\item{response}{An optional response variable}

\item{groups}{A variable or expression to be evaluated in \code{data} and used to
distinguish groups by varying graphical parameters.}

\item{density}{Compute two-dimensional density estimates via \code{\link[MASS:kde2d]{MASS::kde2d()}}.}

\item{region}{Fill density or response estimates with a color gradient.}

\item{contour}{Draw contour lines for density and response estimates.}

\item{labels}{Label contour lines.}

\item{colorkey}{if \code{TRUE} automatically computes a colorkey for density
or response estimates. Can also be a list (see \code{\link[lattice:levelplot]{lattice::levelplot()}} for
details on this).}

\item{xlab}{X axis label (the left dimension)}

\item{ylab}{Y axis label (the right dimension)}

\item{zlab}{Z axis label (the top dimension)}

\item{xlim}{X limits for the plot region.}

\item{ylim}{Y limits for the plot region.}

\item{panel}{The panel function.}

\item{default.prepanel}{The default prepanel function.}

\item{drop.unused.levels}{Drop unused conditioning or groups levels.}

\item{subset}{An expression that evaluates to a logical or integer indexing
vector. Like groups, it is evaluated in data. Only the resulting rows of
data are used for the plot.}
}
\value{
An object of class \code{"trellis"}. The
  \code{\link[lattice:update.trellis]{update}} method can be used to
  update components of the object and the
  \code{\link[lattice:print.trellis]{print}} method (usually called by
  default) will plot it on an appropriate plotting device.
}
\description{
A ternary plot is a triangular diagram that displays proportions of
three variables. It can be used to map three-dimensional data to a
two-dimensional surface with the caveat that the data's original scales are
lost (unless it was proportional data to begin with).#'
}
\section{Methods (by class)}{
\itemize{
\item \code{formula}: A formula of the form \code{top ~ left * right}. Variables
will be evaluated inside data if provided.

\item \code{data.frame}: A data frame for which the first three columns will
be mapped to the \emph{left}, \emph{right}, and \emph{top} dimensions of the ternary plot
respectively.

\item \code{matrix}: A matrix for which the
first three columns will be mapped to the \emph{left}, \emph{right}, and \emph{top}
dimensions of the ternary plot respectively.
}}

\examples{
ternaryplot(Fertility ~ Agriculture * Catholic, data = swiss)
ternaryplot(Catholic ~ Examination * Education, response = Infant.Mortality,
            data = swiss, contour = FALSE)

ternaryplot(Or ~ An * Ab | Feldspar, data = feldspar)

ternaryplot(Or ~ An * Ab, groups = Feldspar, data = feldspar, density = TRUE)
}
