% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab.R
\name{tab_chi2}
\alias{tab_chi2}
\title{Add Chi2 summaries to a \code{\link[tabxplor]{tab}}}
\usage{
tab_chi2(
  tabs,
  calc = c("ctr", "p", "var", "counts"),
  comp = NULL,
  color = c("no", "auto", "all", "all_pct")
)
}
\arguments{
\item{tabs}{A \code{tibble} of class \code{tab}, made with \code{\link{tab_plain}} or
\code{\link{tab_many}}.}

\item{calc}{By default all elements of the Chi2 summary are calculated :
contributions to variance, pvalue, variance and unweighted count. You can choose which
are computed by selecting elements in the vector \code{c("ctr", "p", "var", "counts")}.}

\item{comp}{Comparison level. When \code{tab_vars} are present, should the
contributions to variance be calculated for each subtable/group (by default,
\code{comp = "tab"}) ? Should they be calculated for the whole table
(\code{comp = "all"}) ?
\code{comp} must be set once and for all the first time you use \code{\link{tab_plain}},
\code{\link{tab_num}} or \code{\link{tab_chi2}} with rows, or \code{\link{tab_ci}}.}

\item{color}{The type of colors to print, as a single string.
\itemize{
\item \code{"no"}: by default, no colors are printed
\item \code{"all"}: color all cells based on their contribution to variance
(except for mean columns, from numeric variables)
\item \code{"all_pct"}: color all percentages cells based on their contribution to
variance
\item \code{"auto"}: only color columns with counts, \code{pct = "all"} or
\code{pct = "all_tabs"}
}}
}
\value{
A \code{tibble} of class \code{tab}, with Chi2 summaries as metadata,
possibly colored based on contributions of cells to variance.
}
\description{
Add Chi2 summaries to a \code{\link[tabxplor]{tab}}
}
