/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula.writers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import technology.tabula.RectangularTextContainer;
import technology.tabula.Table;
import technology.tabula.writers.Writer;

public class CSVWriter
implements Writer {
    CSVPrinter printer;
    private boolean useLineReturns = true;

    void createWriter(Appendable out) {
        try {
            this.printer = new CSVPrinter(out, CSVFormat.EXCEL);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void write(Appendable out, Table table) throws IOException {
        this.createWriter(out);
        for (List<RectangularTextContainer> row : table.getRows()) {
            ArrayList<String> cells = new ArrayList<String>(row.size());
            for (RectangularTextContainer tc : row) {
                cells.add(tc.getText());
            }
            this.printer.printRecord(cells);
        }
        this.printer.flush();
    }

    @Override
    public void write(Appendable out, List<Table> tables) throws IOException {
        for (Table table : tables) {
            this.write(out, table);
        }
    }
}

