context("Test Split/Merge")

sf <- system.file("examples", "data.pdf", package = "tabulizer")

test_that("Splitting works", {
  s <- split_pdf(sf)
  npages1 <- get_n_pages(s[1])
  npages2 <- get_n_pages(s[1])
  npages3 <- get_n_pages(s[1])
  expect_true(is.character(s))
  expect_identical(length(s), 3L)
  expect_identical(npages1, 1L)
  expect_identical(npages2, 1L)
  expect_identical(npages3, 1L)
  expect_true(all(file.exists(s)))
  unlink(s)
})

test_that("Split files are saved to tempdir()", {
  fls <- list.files(tempdir())
  s <- split_pdf(sf)
  dirs <- normalizePath(dirname(s))
  expect_true(all(dirs == normalizePath(tempdir())))
  unlink(s)
})

test_that("Test 'copy' argument for splitting", {
  fls <- list.files(tempdir())
  filepath <- file.path(tempdir(), basename(sf))
  s <- split_pdf(sf, copy = TRUE)
  fls2 <- list.files(tempdir())
  expect_true(file.exists(filepath))
  unlink(s)
  unlink(filepath)
})

test_that("Merging works", {
  tmp <- tempfile()
  s <- split_pdf(sf)
  m <- merge_pdfs(s, outfile = tmp)
  npages <- get_n_pages(m)
  expect_true(file.exists(tmp))
  expect_identical(npages, length(s))
  unlink(s)
  unlink(m)
})

test_that("Test 'copy' argument for merging", {
  fls <- list.files(tempdir())
  tmp <- tempfile()
  outdir <- file.path(tempdir(), "split")
  dir.create(outdir)
  s <- split_pdf(sf, outdir = outdir)
  filepaths <- file.path(tempdir(), basename(s))
  m <- merge_pdfs(s, outfile = tmp, copy = TRUE)
  unlink(outdir, recursive = TRUE)
  fls2 <- list.files(tempdir())
  expect_true(all(file.exists(filepaths)))
  expect_true(file.exists(tmp))
  unlink(tmp)
  unlink(filepaths)
  unlink(m)
})
