% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/diversity_alpha.R
\docType{methods}
\name{index_shannon}
\alias{index_shannon}
\alias{index_shannon-method}
\alias{index_shannon,numeric-method}
\title{Shannon-Wiener Diversity Index}
\usage{
index_shannon(x, ...)

\S4method{index_shannon}{numeric}(
  x,
  evenness = FALSE,
  unbiased = FALSE,
  ACE = FALSE,
  base = exp(1),
  na.rm = FALSE,
  ...
)
}
\arguments{
\item{x}{A \code{\link{numeric}} vector of count data (absolute frequencies).}

\item{...}{Currently not used.}

\item{evenness}{A \code{\link{numeric}} scalar: should evenness be computed?}

\item{unbiased}{A \code{\link{logical}} scalar: should the bias-corrected estimator be
used?}

\item{ACE}{A \code{\link{logical}} scalar: should the ACE species richness estimator be
used in the bias correction?}

\item{base}{A positive \code{\link{numeric}} value specifying the base with respect to
which logarithms are computed.}

\item{na.rm}{A \code{\link{numeric}} scalar: should missing values (including \code{NaN}) be
removed?}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Shannon-Wiener Diversity Index
}
\details{
The Shannon index assumes that individuals are randomly sampled from an
infinite population and that all taxa are represented in the sample (it
does not reflect the sample size). The main source of error arises from the
failure to include all taxa in the sample: this error increases as the
proportion of species discovered in the sample declines (Peet 1974,
Magurran 1988). The maximum likelihood estimator (MLE) is used for the
relative abundance, this is known to be negatively biased by sample size.
}
\references{
Peet, R. K. (1974). The Measurement of Species Diversity. \emph{Annual Review of
Ecology and Systematics}, 5(1), 285-307.
\doi{10.1146/annurev.es.05.110174.001441}.

Magurran, A. E. (1988). \emph{Ecological Diversity and its Measurement}.
Princeton, NJ: Princeton University Press.
\doi{10.1007/978-94-015-7358-0}.

Shannon, C. E. (1948). A Mathematical Theory of Communication. \emph{The
Bell System Technical Journal}, 27, 379-423.
\doi{10.1002/j.1538-7305.1948.tb01338.x}.
}
\seealso{
Other alpha diversity measures: 
\code{\link{index_ace}()},
\code{\link{index_baxter}()},
\code{\link{index_berger}()},
\code{\link{index_boone}()},
\code{\link{index_brillouin}()},
\code{\link{index_chao1}()},
\code{\link{index_chao2}()},
\code{\link{index_hurlbert}()},
\code{\link{index_ice}()},
\code{\link{index_margalef}()},
\code{\link{index_mcintosh}()},
\code{\link{index_menhinick}()},
\code{\link{index_simpson}()},
\code{\link{index_squares}()}
}
\author{
N. Frerebeau
}
\concept{alpha diversity measures}
