% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{is_diatonic}
\alias{is_diatonic}
\title{Check if notes and chords are diatonic}
\usage{
is_diatonic(notes, key = "c")
}
\arguments{
\item{notes}{character, a noteworthy string.}

\item{key}{character, key signature.}
}
\value{
logical
}
\description{
Check if notes and chords are diatonic in a given key.
}
\details{
This function is a wrapper around \code{\link[=is_in_scale]{is_in_scale()}}. To check if individual
notes are in a scale, see \code{\link[=note_in_scale]{note_in_scale()}}.
}
\examples{
is_diatonic("ceg ace ce_g", "c")
is_diatonic(c("r", "d", "dfa", "df#a"), "d")
}
\seealso{
\code{\link[=is_in_scale]{is_in_scale()}}
}
