% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableMatrix.R
\name{tab.tableMatrix}
\alias{tab.tableMatrix}
\title{Get or set table attribute}
\usage{
\method{tab}{tableMatrix}(obj, matN = NULL, addRow = FALSE, resetN = TRUE,
  ...)
}
\arguments{
\item{obj}{\code{tableMatrix} object.}

\item{matN}{Integer. Matrix number in \code{mat} list.}

\item{addRow}{Logical. If TRUE column \code{tm.allRow} with row indexes before subsetting
is added.}

\item{resetN}{Logical. Used when matN is specified. When FALSE
\code{tm.matN} of returned tab won't be reseted to 1. Default TRUE.}

\item{...}{Passed arguments.}
}
\value{
Full table part of \code{tableMatrix} or a subset of table part.
}
\description{
\code{tableMatrix} method to get or set table attribute of \code{tableMatrix} object.
}
\examples{

data(images8By8)
data(images10By10)

# Create tableMatrix from images8By8 and images10By10
TM <- tableMatrix(list(images8By8, images10By10), list(1:3, 1:3),
list(4:ncol(images8By8),4:ncol(images10By10)))
matDim(TM)

# Table part of TM
tab(TM)

# Table part of TM corresponding to matrix type 2
tab(TM, 2)

# Add row indexes
tab(TM, 2, TRUE)

}

