% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_second_header_css.R
\name{add_css_second_header}
\alias{add_css_second_header}
\title{Add css to tableHTML's second headers}
\usage{
add_css_second_header(tableHTML, css, second_headers)
}
\arguments{
\item{tableHTML}{A tableHTML object created by the tableHTML function.}

\item{css}{A list of two elements with the corresponding css. The first element of the list
should be an atomic vector with the style definitions (e.g. background-color). The second
element will be an atomic vector with the same length as the first element, which will 
contain the style definitions' values (e.g. red). Check the examples for more information.}

\item{second_headers}{A numeric atomic vector with the indices of the second headers where the 
style definitions will be applied on. At least one second header index must be provided.}
}
\value{
A tableHTML object.
}
\description{
\code{add_css_second_header} will add css to a tableHTML's second headers
}
\details{
\code{add_css_second_header} will add css to a tableHTML's second headers.
}
\examples{
tableHTML(mtcars, second_header = list(c(3, 4, 5), c('col1', 'col2', 'col3'))) \%>\% 
  add_css_second_header(css = list(c('background-color', 'border'), 
                                   c('lightgray', '3px solid green')),
                        second_headers = c(1, 3))  

}

