% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen_BM.R
\name{data.gen.bm}
\alias{data.gen.bm}
\title{Generate a time series of Brownian motion.}
\usage{
data.gen.bm(
  x0 = 0,
  w0 = 0,
  time = seq(0, by = 0.01, length.out = 101),
  do.plot = TRUE
)
}
\arguments{
\item{x0}{the start value of x, with the default value 0}

\item{w0}{the start value of w, with the default value 0}

\item{time}{the temporal interval at which the system will be generated. Default seq(0,by=0.01,len=101).}

\item{do.plot}{a logical value. If TRUE (default value), a plot of the generated system is shown.}
}
\description{
This function generates a time series of one dimension Brownian motion.
}
\examples{
set.seed(123)
x <- data.gen.bm()
}
\references{
Yanping Chen, http://cos.name/wp-content/uploads/2008/12/stochastic-differential-equation-with-r.pdf
}
