% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggswissparl.R
\name{ggswissparl}
\alias{ggswissparl}
\title{Plot voting results}
\usage{
ggswissparl(
  votes,
  seats = NULL,
  highlight,
  result = F,
  result_size = 6,
  point_shape = 16,
  point_size = 4,
  theme = "scoreboard"
)
}
\arguments{
\item{votes}{data of votes of the Swiss National Council as can be retrieved with \code{get_data(table = "Voting")}.
The variables \code{PersonNumber}, \code{Decision}, and \code{DecisionText} must be available from the data.}

\item{seats}{data linking councillors (\code{PersonNumber}) to seats (\code{SeatNumber}). If \code{is.null},
the most current seating order is retrieved via \code{get_data(table = "SeatOrganisationNr")}.}

\item{highlight}{named list with variable and values to specify highlighting of selected councillors.}

\item{result}{if \code{TRUE}, the result is annontated.}

\item{result_size}{font size of result.}

\item{point_shape}{shape of point as defined in \code{[ggplot2]{geom_point}}.}

\item{point_size}{size of point.}

\item{theme}{name of predefined plot theme:
\itemize{
    \item \code{"scoreboard"} imitates the scoreboard in the council hall: neon-red (yes-votes),
    neon-green (no-votes) and white (abstentions) dots on black ground in white frames.
    \item \code{"sym1"} colored symbols on light background in black frames.
    \item \code{"sym2"} colored symbols on light background without frames.
    \item \code{"poly1"} color-filled polygons with black edges.
    \item \code{"poly2"} color-filled polygons with white edges.
    \item \code{"poly3"} color-filled polygons without edges.
    }}
}
\value{
A ggplot object. If \code{votes} contains multiple ballots, \code{[ggplot2]{facet_wrap}} is used to
    create facets.
}
\description{
\code{ggswissparl} plots voting results of the Swiss National Council according to the latest seating order.
}
\examples{
\dontrun{
# Visualization of a vote of the 51st legislature
get_data("Voting", Language = "DE", IdVote = 23458) \%>\%
    ggswissparl()

# Highlighting a parliamentary group
get_data("Voting", Language = "DE", IdVote = 23458) \%>\%
    ggswissparl(highlight = list("ParlGroupNumber" = 2))
}
}
