% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airdas_chop_condition.R
\name{airdas_chop_condition}
\alias{airdas_chop_condition}
\alias{airdas_chop_condition.data.frame}
\alias{airdas_chop_condition.airdas_df}
\title{Chop AirDAS data - condition}
\usage{
airdas_chop_condition(x, ...)

\method{airdas_chop_condition}{data.frame}(x, ...)

\method{airdas_chop_condition}{airdas_df}(
  x,
  conditions,
  seg.min.km = 0.1,
  distance.method = NULL,
  num.cores = NULL,
  ...
)
}
\arguments{
\item{x}{\code{airdas_df} object, 
or a data frame that can be coerced to a \code{airdas_df} object. 
This data must be filtered for 'OnEffort' events; 
see the Details section below}

\item{...}{ignored}

\item{conditions}{the conditions that trigger a new segment; 
see \code{\link{airdas_effort}}}

\item{seg.min.km}{numeric; minimum allowable segment length (in kilometers).
Default is 0.1. See the Details section below for more information}

\item{distance.method}{character; see \code{\link{airdas_effort}}.
Default is \code{NULL} since these distances should have already been
calculated in \code{\link{airdas_effort}}}

\item{num.cores}{See \code{\link{airdas_effort}}}
}
\value{
List of two data frames:
\itemize{
  \item \code{x}, with columns added for the corresponding unique segment code and number
  \item segdata: data frame with one row for each segment, and columns with
    relevant data (see \code{\link{airdas_effort}} for specifics)
}
}
\description{
Chop AirDAS data into a new effort segment every time a condition changes
}
\details{
WARNING - do not call this function directly!
  It is exported for documentation purposes, but is intended for internal package use only.

  This function is intended to only be called by \code{\link{airdas_effort}} 
  when the "condition" method is specified. 
  Thus, \code{x} must be filtered for events (rows) where either
  the 'OnEffort' column is \code{TRUE} or the 'Event' column is either "E" or "O"; 
  see \code{\link{airdas_effort}} for more details. 
  This function chops each continuous effort section (henceforth 'effort sections') 
  in \code{x} into modeling segments (henceforth 'segments') by 
  creating a new segment every time a condition changes. 
  Each effort section runs from a T/R event to its corresponding E/O event. 
  After chopping, \code{\link{airdas_segdata}} is called 
  (with \code{segdata.method = "maxdist"})
  to get relevant segdata information for each segment.
  
  Changes in the one of the conditions specified in the \code{conditions}
  argument triggers a new segment.
  An exception is when multiple condition changes happen at
  the same location, such as a 'TVPAW' series of events.
  When this happens, no segments of length zero are created;
  rather, a single segment is created that includes all of the condition changes
  (i.e. all of the events in the event series) that happened during
  the series of events (i.e. at the same location).
  Note that this combining of events at the same Lat/Lon happens
  even if \code{seg.min.km = 0}.
  
  In addition, (almost) all segments whose length is less than \code{seg.min.km}
  are combined with the segment immediately following them to ensure that the length
  of (almost) all segments is at least \code{seg.min.km}.
  This allows users to account for situations where multiple conditions,
  such as Beaufort and a viewing condition, change in rapid succession, say <0.1 km apart.
  When segments are combined, a message is printed, and the condition that was
  recorded for the maximum distance within the new segment is reported.
  See \code{\link{airdas_segdata}}, \code{segdata.method = "maxdist"}, for more details
  about how the segdata information is determined.
  The only exception to this rule is if the short segment ends in an "E" or an "O" event,
  meaning it is the last segment of the effort section.
  Since in this case there is no 'next' segment,
  this short segment is left as-is.

  If the column \code{dist_from_prev} does not exist, the distance between
  subsequent events is calculated as described in \code{\link{airdas_effort}}
}
