% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pin.R
\name{pin_ctrl}
\alias{pin_ctrl}
\title{Check control number from \code{pin}}
\usage{
pin_ctrl(pin)
}
\arguments{
\item{pin}{A vector of class \code{pin}. See \link{as.pin}.}
}
\value{
Logical vector indicating if a pin is correct (\code{TRUE}) or not (\code{FALSE})
}
\description{
Calculates the control number using the Luhn algorithm and compare it with the
control number in the personal identity number.
}
\examples{
# Examples taken from SKV 704 (see references)
ex_pin <- c("196408233234", "196408233235")
pin_ctrl(ex_pin)
}
\references{
\href{https://www.skatteverket.se/download/18.8dcbbe4142d38302d74be9/1387372677724/717B06.pdf}{Population registration in Sweden}
\href{https://www.skatteverket.se/download/18.1e6d5f87115319ffba380001857/1285595720207/70408.pdf}{SKV 704}
\href{http://www.riksdagen.se/sv/Dokument-Lagar/Utredningar/Statens-offentliga-utredningar/Personnummer-och-samordningsnu_GWB360/}{SOU 2008:60 : Personnummer och samordningsnummer}
}

