% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/about.R
\name{about}
\alias{about}
\alias{?}
\title{Get information and help about \R objects}
\usage{
about(topic, ...)

"?"(type, topic)
}
\arguments{
\item{topic}{The name of an object, or the topic to search for, if this is
not the name of a known object.}

\item{...}{Further arguments passed to \code{\link[=help]{help()}}.}

\item{type}{First argument to \code{?}. If it is a dot, like \code{.?topic}, the second
argument is a topic passed to the \code{about()} function. Otherwise, it is the
first argument to restrict help pages, like \code{class}, \code{methods}, or \code{method}.
See examples for how to use it.}
}
\value{
A string with the location of all objects named \code{topic} are found is
returned invisibly.
}
\description{
Help obtained with this function is wider than with \code{\link[=help]{help()}}. If
a man page is not found, it suggests related topics. If an object is an S3
generic function, it also lists all its known methods. Also, one can track
the help page of an object even if its name is changed, by using the \code{src} or
\code{srcfile} attribute of the object's comment. By the way, if the object has a
comment, it is also displayed. This can be used as a quick and dirty way to
provide short hints to custom objects. Finally, it is possible to track down
the source of an object into a file with the \code{srcfile} attribute of its
comment. In this case, it is the source file that is displayed. So, you can
also further document your custom objects easily in their source files!
}
\examples{
about("nonexisting") # Not found on search path, but help pages
about("htgdsfgfdsgf") # Not found anywhere
#library(tidyverse)
#about("group_by") # Just one page
#about("filter") # Several items
about("stats::filter") # OK
#about("dplyr::filter") # OK too
about("base::filter") # Not found there
# Objects with comment: print comment
vec <- structure(1:10, comment = "A simple vector")
about("vec")
# If there is a srcfile attribute in the comment, also display the file
# Hint: integrate some help in the header!
#library(data)
#(iris <- read(data_example("iris.csv")))
#about("iris")
# If the comment has a src attribute, change the topic to that one
#urchin <- read("urchin_bio", package = "data")
#about("urchin")
.?filter
.?stats::filter
}
\seealso{
\code{\link[=help]{help()}}, \code{\link[=help.search]{help.search()}}, \code{\link[=apropos]{apropos()}}
}
\concept{
help and information about objects
}
\keyword{utilities}
