% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlg_dir.R
\name{dlg_dir}
\alias{dlg_dir}
\alias{dlgDir}
\alias{dlgDir.gui}
\alias{dlgDir.textCLI}
\alias{dlgDir.nativeGUI}
\title{Modal dialog to select a directory.}
\usage{
dlg_dir(default = getwd(), title, ..., gui = .GUI)

dlgDir(default = getwd(), title, ..., gui = .GUI)

\method{dlgDir}{gui}(default = getwd(), title, ..., gui = .GUI)

\method{dlgDir}{textCLI}(default = getwd(), title, ..., gui = .GUI)

\method{dlgDir}{nativeGUI}(
  default = getwd(),
  title,
  rstudio = getOption("svDialogs.rstudio", TRUE),
  ...,
  gui = .GUI
)
}
\arguments{
\item{default}{The path to the default directory that is proposed (e.g.,
current working directory).}

\item{title}{A title to display on top of the dialog box.}

\item{...}{Pass further arguments to methods.}

\item{gui}{The 'gui' object concerned by this dialog box.}

\item{rstudio}{Logical. Should 'RStudio' dialog boxes automatically be used
if available? If \code{FALSE}, force using OS dialog boxes, but only in
'RStudio Desktop' (ignored in 'RStudio Server'). Can be changed globally
with \code{options(svDialogs.rstudio = TRUE|FALSE)}. \code{TRUE} by default.}
}
\value{
The modified 'gui' object is returned invisibly. Use its \code{gui$res}
component to get the returned directory (the string is empty when the user
cancelled the dialog box, see example).
}
\description{
Select an existing directory, or create a new one.
}
\examples{
\dontrun{
# A quick default directory changer
setwd(dlg_dir(default = getwd())$res)
}
}
\seealso{
\code{\link[=dlg_open]{dlg_open()}}, \code{\link[=dlg_save]{dlg_save()}}
}
\concept{Modal dialog box}
\keyword{misc}
