% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iter_get_cox_res.R
\name{iter_get_cox_res}
\alias{iter_get_cox_res}
\title{Runs get_cox_res Over a Range of Features}
\usage{
iter_get_cox_res(in.df, endpoint, endpoint.code, features, group = NULL)
}
\arguments{
\item{in.df}{Input data.frame.}

\item{endpoint}{Column name of the endpoint.}

\item{endpoint.code}{Column name of the endpoint status code.}

\item{features}{This must be a list of features.}

\item{group}{Column name containing the groups to run cox regression on. If,
specified, cox regression is run separately for each group.}
}
\value{
List of data frames with each data frame being the output of 
  \code{get_cox_res}.
}
\description{
This is a modified version of \code{get_cox_res} allowing for multiple runs
of get_cox_res.
}
\examples{
library("survival")
endpoint <- "time"
endpoint.code <- "status"

# Run Cox Regression on List of Features
features <- list(c("age", "obstruct"),
                 c("nodes"))

iter_get_cox_res(colon, endpoint, endpoint.code, features,
                  group = "rx")
}

