// Generated by rstantools.  Do not edit by hand.

/*
    survstan is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    survstan is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with survstan.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_survreg_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_survreg");
    reader.add_event(2, 2, "include", "/inst/stan/chunks/baselines.stan");
    reader.add_event(2, 0, "start", "/inst/stan/chunks/baselines.stan");
    reader.add_event(54, 52, "end", "/inst/stan/chunks/baselines.stan");
    reader.add_event(54, 3, "restart", "model_survreg");
    reader.add_event(54, 3, "include", "/inst/stan/chunks/loglikelihoods.stan");
    reader.add_event(54, 0, "start", "/inst/stan/chunks/loglikelihoods.stan");
    reader.add_event(113, 59, "end", "/inst/stan/chunks/loglikelihoods.stan");
    reader.add_event(113, 4, "restart", "model_survreg");
    reader.add_event(254, 143, "end", "model_survreg");
    return reader;
}
template <bool propto, typename T0__, typename T1__, typename T2__>
typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
loglogistic_lpdf(const T0__& x,
                     const T1__& alpha,
                     const T2__& gamma, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 9;
        local_scalar_t__ aux(DUMMY_VAR__);
        (void) aux;  // dummy to suppress unused var warning
        stan::math::initialize(aux, DUMMY_VAR__);
        stan::math::fill(aux, DUMMY_VAR__);
        stan::math::assign(aux,stan::math::log1p(pow((x / gamma), alpha)));
        current_statement_begin__ = 10;
        local_scalar_t__ lpdf(DUMMY_VAR__);
        (void) lpdf;  // dummy to suppress unused var warning
        stan::math::initialize(lpdf, DUMMY_VAR__);
        stan::math::fill(lpdf, DUMMY_VAR__);
        stan::math::assign(lpdf,((((stan::math::log(alpha) - stan::math::log(gamma)) + multiply_log((alpha - 1), x)) - multiply_log((alpha - 1), gamma)) - (2 * aux)));
        current_statement_begin__ = 12;
        return stan::math::promote_scalar<fun_return_scalar_t__>(lpdf);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__>
typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
loglogistic_lpdf(const T0__& x,
                     const T1__& alpha,
                     const T2__& gamma, std::ostream* pstream__) {
    return loglogistic_lpdf<false>(x,alpha,gamma, pstream__);
}
struct loglogistic_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
    operator()(const T0__& x,
                     const T1__& alpha,
                     const T2__& gamma, std::ostream* pstream__) const {
        return loglogistic_lpdf(x, alpha, gamma, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
loglogistic_lccdf(const T0__& x,
                      const T1__& alpha,
                      const T2__& gamma, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 16;
        local_scalar_t__ lsurv(DUMMY_VAR__);
        (void) lsurv;  // dummy to suppress unused var warning
        stan::math::initialize(lsurv, DUMMY_VAR__);
        stan::math::fill(lsurv, DUMMY_VAR__);
        stan::math::assign(lsurv,-(stan::math::log1p(pow((x / gamma), alpha))));
        current_statement_begin__ = 17;
        return stan::math::promote_scalar<fun_return_scalar_t__>(lsurv);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct loglogistic_lccdf_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
    operator()(const T0__& x,
                      const T1__& alpha,
                      const T2__& gamma, std::ostream* pstream__) const {
        return loglogistic_lccdf(x, alpha, gamma, pstream__);
    }
};
template <bool propto, typename T0__, typename T1__, typename T2__>
typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
fatigue_lpdf(const T0__& x,
                 const T1__& alpha,
                 const T2__& gamma, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 43;
        local_scalar_t__ aux1(DUMMY_VAR__);
        (void) aux1;  // dummy to suppress unused var warning
        stan::math::initialize(aux1, DUMMY_VAR__);
        stan::math::fill(aux1, DUMMY_VAR__);
        stan::math::assign(aux1,(stan::math::sqrt((x / gamma)) + stan::math::sqrt((gamma / x))));
        current_statement_begin__ = 44;
        local_scalar_t__ aux2(DUMMY_VAR__);
        (void) aux2;  // dummy to suppress unused var warning
        stan::math::initialize(aux2, DUMMY_VAR__);
        stan::math::fill(aux2, DUMMY_VAR__);
        stan::math::assign(aux2,((stan::math::sqrt((x / gamma)) - stan::math::sqrt((gamma / x))) / alpha));
        current_statement_begin__ = 45;
        local_scalar_t__ lpdf(DUMMY_VAR__);
        (void) lpdf;  // dummy to suppress unused var warning
        stan::math::initialize(lpdf, DUMMY_VAR__);
        stan::math::fill(lpdf, DUMMY_VAR__);
        stan::math::assign(lpdf,((stan::math::log(aux1) - stan::math::log(((2 * alpha) * x))) + normal_log(aux2, 0, 1)));
        current_statement_begin__ = 46;
        return stan::math::promote_scalar<fun_return_scalar_t__>(lpdf);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__>
typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
fatigue_lpdf(const T0__& x,
                 const T1__& alpha,
                 const T2__& gamma, std::ostream* pstream__) {
    return fatigue_lpdf<false>(x,alpha,gamma, pstream__);
}
struct fatigue_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
    operator()(const T0__& x,
                 const T1__& alpha,
                 const T2__& gamma, std::ostream* pstream__) const {
        return fatigue_lpdf(x, alpha, gamma, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
fatigue_lccdf(const T0__& x,
                  const T1__& alpha,
                  const T2__& gamma, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 50;
        local_scalar_t__ aux(DUMMY_VAR__);
        (void) aux;  // dummy to suppress unused var warning
        stan::math::initialize(aux, DUMMY_VAR__);
        stan::math::fill(aux, DUMMY_VAR__);
        stan::math::assign(aux,((stan::math::sqrt((x / gamma)) - stan::math::sqrt((gamma / x))) / alpha));
        current_statement_begin__ = 51;
        return stan::math::promote_scalar<fun_return_scalar_t__>(normal_cdf_log(-(aux), 0, 1));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct fatigue_lccdf_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
    operator()(const T0__& x,
                  const T1__& alpha,
                  const T2__& gamma, std::ostream* pstream__) const {
        return fatigue_lccdf(x, alpha, gamma, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic, 1>
loglik_aft(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& lpdf,
               const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& lsurv,
               const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& event,
               const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& lp,
               const T4__& tau, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 58;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,num_elements(lpdf));
        current_statement_begin__ = 59;
        validate_non_negative_index("loglik", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> loglik(n);
        stan::math::initialize(loglik, DUMMY_VAR__);
        stan::math::fill(loglik, DUMMY_VAR__);
        current_statement_begin__ = 60;
        stan::math::assign(loglik, add(elt_multiply(event, subtract(subtract(lpdf, lp), stan::math::log(tau))), elt_multiply(subtract(1, event), lsurv)));
        current_statement_begin__ = 61;
        return stan::math::promote_scalar<fun_return_scalar_t__>(loglik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct loglik_aft_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& lpdf,
               const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& lsurv,
               const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& event,
               const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& lp,
               const T4__& tau, std::ostream* pstream__) const {
        return loglik_aft(lpdf, lsurv, event, lp, tau, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic, 1>
loglik_ah(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& lpdf,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& lsurv,
              const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& event,
              const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& lp,
              const T4__& tau, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 66;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,num_elements(lpdf));
        current_statement_begin__ = 67;
        validate_non_negative_index("loglik", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> loglik(n);
        stan::math::initialize(loglik, DUMMY_VAR__);
        stan::math::fill(loglik, DUMMY_VAR__);
        current_statement_begin__ = 68;
        stan::math::assign(loglik, add(elt_multiply(event, subtract(subtract(lpdf, lsurv), stan::math::log(tau))), elt_multiply(stan::math::exp(minus(lp)), lsurv)));
        current_statement_begin__ = 69;
        return stan::math::promote_scalar<fun_return_scalar_t__>(loglik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct loglik_ah_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& lpdf,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& lsurv,
              const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& event,
              const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& lp,
              const T4__& tau, std::ostream* pstream__) const {
        return loglik_ah(lpdf, lsurv, event, lp, tau, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic, 1>
loglik_ph(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& lpdf,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& lsurv,
              const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& event,
              const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& lp,
              const T4__& tau, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 74;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,num_elements(lpdf));
        current_statement_begin__ = 75;
        validate_non_negative_index("loglik", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> loglik(n);
        stan::math::initialize(loglik, DUMMY_VAR__);
        stan::math::fill(loglik, DUMMY_VAR__);
        current_statement_begin__ = 76;
        validate_non_negative_index("lht", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lht(n);
        stan::math::initialize(lht, DUMMY_VAR__);
        stan::math::fill(lht, DUMMY_VAR__);
        stan::math::assign(lht,subtract(lpdf, lsurv));
        current_statement_begin__ = 77;
        stan::math::assign(loglik, add(elt_multiply(event, subtract(add(lht, lp), stan::math::log(tau))), elt_multiply(stan::math::exp(lp), lsurv)));
        current_statement_begin__ = 78;
        return stan::math::promote_scalar<fun_return_scalar_t__>(loglik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct loglik_ph_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& lpdf,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& lsurv,
              const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& event,
              const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& lp,
              const T4__& tau, std::ostream* pstream__) const {
        return loglik_ph(lpdf, lsurv, event, lp, tau, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic, 1>
loglik_po(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& lpdf,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& lsurv,
              const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& event,
              const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& lp,
              const T4__& tau, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 83;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,num_elements(lpdf));
        current_statement_begin__ = 84;
        validate_non_negative_index("lht", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lht(n);
        stan::math::initialize(lht, DUMMY_VAR__);
        stan::math::fill(lht, DUMMY_VAR__);
        stan::math::assign(lht,subtract(lpdf, lsurv));
        current_statement_begin__ = 85;
        validate_non_negative_index("Ht", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> Ht(n);
        stan::math::initialize(Ht, DUMMY_VAR__);
        stan::math::fill(Ht, DUMMY_VAR__);
        stan::math::assign(Ht,minus(lsurv));
        current_statement_begin__ = 86;
        validate_non_negative_index("aux", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> aux(n);
        stan::math::initialize(aux, DUMMY_VAR__);
        stan::math::fill(aux, DUMMY_VAR__);
        stan::math::assign(aux,elt_multiply(stan::math::exp(lp), stan::math::expm1(Ht)));
        current_statement_begin__ = 87;
        validate_non_negative_index("loglik", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> loglik(n);
        stan::math::initialize(loglik, DUMMY_VAR__);
        stan::math::fill(loglik, DUMMY_VAR__);
        stan::math::assign(loglik,subtract(elt_multiply(event, subtract(add(add(lht, lp), Ht), stan::math::log(tau))), elt_multiply(add(1, event), stan::math::log1p(aux))));
        current_statement_begin__ = 88;
        return stan::math::promote_scalar<fun_return_scalar_t__>(loglik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct loglik_po_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& lpdf,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& lsurv,
              const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& event,
              const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& lp,
              const T4__& tau, std::ostream* pstream__) const {
        return loglik_po(lpdf, lsurv, event, lp, tau, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type, Eigen::Dynamic, 1>
loglik_yp(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& status,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& lpdf,
              const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& lsurv,
              const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& lp_short,
              const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& lp_long,
              const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& ratio,
              const T6__& tau, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 94;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,num_elements(lpdf));
        current_statement_begin__ = 95;
        validate_non_negative_index("Rt0", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> Rt0(n);
        stan::math::initialize(Rt0, DUMMY_VAR__);
        stan::math::fill(Rt0, DUMMY_VAR__);
        current_statement_begin__ = 96;
        validate_non_negative_index("log_ht", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_ht(n);
        stan::math::initialize(log_ht, DUMMY_VAR__);
        stan::math::fill(log_ht, DUMMY_VAR__);
        current_statement_begin__ = 97;
        validate_non_negative_index("log_St", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_St(n);
        stan::math::initialize(log_St, DUMMY_VAR__);
        stan::math::fill(log_St, DUMMY_VAR__);
        current_statement_begin__ = 98;
        validate_non_negative_index("loglik", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> loglik(n);
        stan::math::initialize(loglik, DUMMY_VAR__);
        stan::math::fill(loglik, DUMMY_VAR__);
        current_statement_begin__ = 99;
        validate_non_negative_index("theta", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta(n);
        stan::math::initialize(theta, DUMMY_VAR__);
        stan::math::fill(theta, DUMMY_VAR__);
        current_statement_begin__ = 100;
        validate_non_negative_index("aux", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> aux(n);
        stan::math::initialize(aux, DUMMY_VAR__);
        stan::math::fill(aux, DUMMY_VAR__);
        current_statement_begin__ = 101;
        validate_non_negative_index("lht0", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lht0(n);
        stan::math::initialize(lht0, DUMMY_VAR__);
        stan::math::fill(lht0, DUMMY_VAR__);
        stan::math::assign(lht0,subtract(subtract(lpdf, lsurv), stan::math::log(tau)));
        current_statement_begin__ = 102;
        validate_non_negative_index("Ht0", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> Ht0(n);
        stan::math::initialize(Ht0, DUMMY_VAR__);
        stan::math::fill(Ht0, DUMMY_VAR__);
        stan::math::assign(Ht0,minus(lsurv));
        current_statement_begin__ = 104;
        stan::math::assign(Rt0, stan::math::expm1(Ht0));
        current_statement_begin__ = 105;
        stan::math::assign(theta, stan::math::exp(lp_long));
        current_statement_begin__ = 107;
        stan::math::assign(aux, elt_multiply(ratio, Rt0));
        current_statement_begin__ = 108;
        stan::math::assign(log_ht, add(add(subtract(lp_short, stan::math::log1p(aux)), lht0), Ht0));
        current_statement_begin__ = 109;
        stan::math::assign(log_St, elt_multiply(minus(theta), stan::math::log1p(aux)));
        current_statement_begin__ = 110;
        stan::math::assign(loglik, add(elt_multiply(status, log_ht), log_St));
        current_statement_begin__ = 112;
        return stan::math::promote_scalar<fun_return_scalar_t__>(loglik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct loglik_yp_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& status,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& lpdf,
              const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& lsurv,
              const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& lp_short,
              const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& lp_long,
              const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& ratio,
              const T6__& tau, std::ostream* pstream__) const {
        return loglik_yp(status, lpdf, lsurv, lp_short, lp_long, ratio, tau, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_survreg
  : public stan::model::model_base_crtp<model_survreg> {
private:
        int n;
        int p;
        vector_d time;
        vector_d event;
        matrix_d X;
        double tau;
        int baseline;
        int survreg;
        int is_alpha;
        int is_gamma;
        int is_lambda;
        int is_mu;
        int is_sigma;
        int is_phi;
        vector_d zeros;
public:
    model_survreg(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_survreg(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_survreg_namespace::model_survreg";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 117;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            current_statement_begin__ = 118;
            context__.validate_dims("data initialization", "p", "int", context__.to_vec());
            p = int(0);
            vals_i__ = context__.vals_i("p");
            pos__ = 0;
            p = vals_i__[pos__++];
            current_statement_begin__ = 119;
            validate_non_negative_index("time", "n", n);
            context__.validate_dims("data initialization", "time", "vector_d", context__.to_vec(n));
            time = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("time");
            pos__ = 0;
            size_t time_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < time_j_1_max__; ++j_1__) {
                time(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 120;
            validate_non_negative_index("event", "n", n);
            context__.validate_dims("data initialization", "event", "vector_d", context__.to_vec(n));
            event = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("event");
            pos__ = 0;
            size_t event_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < event_j_1_max__; ++j_1__) {
                event(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 121;
            validate_non_negative_index("X", "(logical_eq(p, 0) ? 0 : n )", (logical_eq(p, 0) ? 0 : n ));
            validate_non_negative_index("X", "p", p);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec((logical_eq(p, 0) ? 0 : n ),p));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((logical_eq(p, 0) ? 0 : n ), p);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = p;
            size_t X_j_1_max__ = (logical_eq(p, 0) ? 0 : n );
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 122;
            context__.validate_dims("data initialization", "tau", "double", context__.to_vec());
            tau = double(0);
            vals_r__ = context__.vals_r("tau");
            pos__ = 0;
            tau = vals_r__[pos__++];
            current_statement_begin__ = 123;
            context__.validate_dims("data initialization", "baseline", "int", context__.to_vec());
            baseline = int(0);
            vals_i__ = context__.vals_i("baseline");
            pos__ = 0;
            baseline = vals_i__[pos__++];
            current_statement_begin__ = 124;
            context__.validate_dims("data initialization", "survreg", "int", context__.to_vec());
            survreg = int(0);
            vals_i__ = context__.vals_i("survreg");
            pos__ = 0;
            survreg = vals_i__[pos__++];
            // initialize transformed data variables
            current_statement_begin__ = 128;
            is_alpha = int(0);
            stan::math::fill(is_alpha, std::numeric_limits<int>::min());
            stan::math::assign(is_alpha,0);
            current_statement_begin__ = 129;
            is_gamma = int(0);
            stan::math::fill(is_gamma, std::numeric_limits<int>::min());
            stan::math::assign(is_gamma,0);
            current_statement_begin__ = 130;
            is_lambda = int(0);
            stan::math::fill(is_lambda, std::numeric_limits<int>::min());
            stan::math::assign(is_lambda,0);
            current_statement_begin__ = 131;
            is_mu = int(0);
            stan::math::fill(is_mu, std::numeric_limits<int>::min());
            stan::math::assign(is_mu,0);
            current_statement_begin__ = 132;
            is_sigma = int(0);
            stan::math::fill(is_sigma, std::numeric_limits<int>::min());
            stan::math::assign(is_sigma,0);
            current_statement_begin__ = 133;
            is_phi = int(0);
            stan::math::fill(is_phi, std::numeric_limits<int>::min());
            stan::math::assign(is_phi,0);
            current_statement_begin__ = 135;
            validate_non_negative_index("zeros", "(logical_eq(p, 0) ? n : 0 )", (logical_eq(p, 0) ? n : 0 ));
            zeros = Eigen::Matrix<double, Eigen::Dynamic, 1>((logical_eq(p, 0) ? n : 0 ));
            stan::math::fill(zeros, DUMMY_VAR__);
            // execute transformed data statements
            current_statement_begin__ = 137;
            if (as_bool(logical_eq(p, 0))) {
                current_statement_begin__ = 138;
                for (int i = 1; i <= n; ++i) {
                    current_statement_begin__ = 139;
                    stan::model::assign(zeros, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                0, 
                                "assigning variable zeros");
                }
            }
            current_statement_begin__ = 143;
            if (as_bool(logical_eq(baseline, 1))) {
                current_statement_begin__ = 144;
                stan::math::assign(is_lambda, 1);
            } else if (as_bool(logical_eq(baseline, 2))) {
                current_statement_begin__ = 146;
                stan::math::assign(is_alpha, 1);
                current_statement_begin__ = 147;
                stan::math::assign(is_gamma, 1);
            } else if (as_bool(logical_eq(baseline, 3))) {
                current_statement_begin__ = 149;
                stan::math::assign(is_mu, 1);
                current_statement_begin__ = 150;
                stan::math::assign(is_sigma, 1);
            } else if (as_bool(logical_eq(baseline, 4))) {
                current_statement_begin__ = 152;
                stan::math::assign(is_alpha, 1);
                current_statement_begin__ = 153;
                stan::math::assign(is_gamma, 1);
            } else if (as_bool(logical_eq(baseline, 5))) {
                current_statement_begin__ = 155;
                stan::math::assign(is_alpha, 1);
                current_statement_begin__ = 156;
                stan::math::assign(is_gamma, 1);
            }
            current_statement_begin__ = 159;
            if (as_bool(logical_eq(survreg, 5))) {
                current_statement_begin__ = 160;
                stan::math::assign(is_phi, 1);
            }
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 167;
            validate_non_negative_index("beta", "(logical_eq(p, 0) ? 0 : p )", (logical_eq(p, 0) ? 0 : p ));
            num_params_r__ += (logical_eq(p, 0) ? 0 : p );
            current_statement_begin__ = 168;
            validate_non_negative_index("phi", "(logical_eq(is_phi, 0) ? 0 : p )", (logical_eq(is_phi, 0) ? 0 : p ));
            num_params_r__ += (logical_eq(is_phi, 0) ? 0 : p );
            current_statement_begin__ = 169;
            validate_non_negative_index("alpha", "(logical_eq(is_alpha, 0) ? 0 : 1 )", (logical_eq(is_alpha, 0) ? 0 : 1 ));
            num_params_r__ += (1 * (logical_eq(is_alpha, 0) ? 0 : 1 ));
            current_statement_begin__ = 170;
            validate_non_negative_index("gamma", "(logical_eq(is_gamma, 0) ? 0 : 1 )", (logical_eq(is_gamma, 0) ? 0 : 1 ));
            num_params_r__ += (1 * (logical_eq(is_gamma, 0) ? 0 : 1 ));
            current_statement_begin__ = 171;
            validate_non_negative_index("lambda", "(logical_eq(is_lambda, 0) ? 0 : 1 )", (logical_eq(is_lambda, 0) ? 0 : 1 ));
            num_params_r__ += (1 * (logical_eq(is_lambda, 0) ? 0 : 1 ));
            current_statement_begin__ = 172;
            validate_non_negative_index("mu", "(logical_eq(is_mu, 0) ? 0 : 1 )", (logical_eq(is_mu, 0) ? 0 : 1 ));
            num_params_r__ += (1 * (logical_eq(is_mu, 0) ? 0 : 1 ));
            current_statement_begin__ = 173;
            validate_non_negative_index("sigma", "(logical_eq(is_sigma, 0) ? 0 : 1 )", (logical_eq(is_sigma, 0) ? 0 : 1 ));
            num_params_r__ += (1 * (logical_eq(is_sigma, 0) ? 0 : 1 ));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_survreg() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 167;
        if (!(context__.contains_r("beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "(logical_eq(p, 0) ? 0 : p )", (logical_eq(p, 0) ? 0 : p ));
        context__.validate_dims("parameter initialization", "beta", "vector_d", context__.to_vec((logical_eq(p, 0) ? 0 : p )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta((logical_eq(p, 0) ? 0 : p ));
        size_t beta_j_1_max__ = (logical_eq(p, 0) ? 0 : p );
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            beta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 168;
        if (!(context__.contains_r("phi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable phi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("phi");
        pos__ = 0U;
        validate_non_negative_index("phi", "(logical_eq(is_phi, 0) ? 0 : p )", (logical_eq(is_phi, 0) ? 0 : p ));
        context__.validate_dims("parameter initialization", "phi", "vector_d", context__.to_vec((logical_eq(is_phi, 0) ? 0 : p )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> phi((logical_eq(is_phi, 0) ? 0 : p ));
        size_t phi_j_1_max__ = (logical_eq(is_phi, 0) ? 0 : p );
        for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
            phi(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(phi);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable phi: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 169;
        if (!(context__.contains_r("alpha")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        validate_non_negative_index("alpha", "(logical_eq(is_alpha, 0) ? 0 : 1 )", (logical_eq(is_alpha, 0) ? 0 : 1 ));
        context__.validate_dims("parameter initialization", "alpha", "double", context__.to_vec((logical_eq(is_alpha, 0) ? 0 : 1 )));
        std::vector<double> alpha((logical_eq(is_alpha, 0) ? 0 : 1 ), double(0));
        size_t alpha_k_0_max__ = (logical_eq(is_alpha, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
            alpha[k_0__] = vals_r__[pos__++];
        }
        size_t alpha_i_0_max__ = (logical_eq(is_alpha, 0) ? 0 : 1 );
        for (size_t i_0__ = 0; i_0__ < alpha_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, alpha[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 170;
        if (!(context__.contains_r("gamma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gamma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gamma");
        pos__ = 0U;
        validate_non_negative_index("gamma", "(logical_eq(is_gamma, 0) ? 0 : 1 )", (logical_eq(is_gamma, 0) ? 0 : 1 ));
        context__.validate_dims("parameter initialization", "gamma", "double", context__.to_vec((logical_eq(is_gamma, 0) ? 0 : 1 )));
        std::vector<double> gamma((logical_eq(is_gamma, 0) ? 0 : 1 ), double(0));
        size_t gamma_k_0_max__ = (logical_eq(is_gamma, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < gamma_k_0_max__; ++k_0__) {
            gamma[k_0__] = vals_r__[pos__++];
        }
        size_t gamma_i_0_max__ = (logical_eq(is_gamma, 0) ? 0 : 1 );
        for (size_t i_0__ = 0; i_0__ < gamma_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, gamma[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gamma: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 171;
        if (!(context__.contains_r("lambda")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lambda missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lambda");
        pos__ = 0U;
        validate_non_negative_index("lambda", "(logical_eq(is_lambda, 0) ? 0 : 1 )", (logical_eq(is_lambda, 0) ? 0 : 1 ));
        context__.validate_dims("parameter initialization", "lambda", "double", context__.to_vec((logical_eq(is_lambda, 0) ? 0 : 1 )));
        std::vector<double> lambda((logical_eq(is_lambda, 0) ? 0 : 1 ), double(0));
        size_t lambda_k_0_max__ = (logical_eq(is_lambda, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < lambda_k_0_max__; ++k_0__) {
            lambda[k_0__] = vals_r__[pos__++];
        }
        size_t lambda_i_0_max__ = (logical_eq(is_lambda, 0) ? 0 : 1 );
        for (size_t i_0__ = 0; i_0__ < lambda_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, lambda[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lambda: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 172;
        if (!(context__.contains_r("mu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        validate_non_negative_index("mu", "(logical_eq(is_mu, 0) ? 0 : 1 )", (logical_eq(is_mu, 0) ? 0 : 1 ));
        context__.validate_dims("parameter initialization", "mu", "double", context__.to_vec((logical_eq(is_mu, 0) ? 0 : 1 )));
        std::vector<double> mu((logical_eq(is_mu, 0) ? 0 : 1 ), double(0));
        size_t mu_k_0_max__ = (logical_eq(is_mu, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
            mu[k_0__] = vals_r__[pos__++];
        }
        size_t mu_i_0_max__ = (logical_eq(is_mu, 0) ? 0 : 1 );
        for (size_t i_0__ = 0; i_0__ < mu_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_unconstrain(mu[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 173;
        if (!(context__.contains_r("sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "(logical_eq(is_sigma, 0) ? 0 : 1 )", (logical_eq(is_sigma, 0) ? 0 : 1 ));
        context__.validate_dims("parameter initialization", "sigma", "double", context__.to_vec((logical_eq(is_sigma, 0) ? 0 : 1 )));
        std::vector<double> sigma((logical_eq(is_sigma, 0) ? 0 : 1 ), double(0));
        size_t sigma_k_0_max__ = (logical_eq(is_sigma, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            sigma[k_0__] = vals_r__[pos__++];
        }
        size_t sigma_i_0_max__ = (logical_eq(is_sigma, 0) ? 0 : 1 );
        for (size_t i_0__ = 0; i_0__ < sigma_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, sigma[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 167;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.vector_constrain((logical_eq(p, 0) ? 0 : p ), lp__);
            else
                beta = in__.vector_constrain((logical_eq(p, 0) ? 0 : p ));
            current_statement_begin__ = 168;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> phi;
            (void) phi;  // dummy to suppress unused var warning
            if (jacobian__)
                phi = in__.vector_constrain((logical_eq(is_phi, 0) ? 0 : p ), lp__);
            else
                phi = in__.vector_constrain((logical_eq(is_phi, 0) ? 0 : p ));
            current_statement_begin__ = 169;
            std::vector<local_scalar_t__> alpha;
            size_t alpha_d_0_max__ = (logical_eq(is_alpha, 0) ? 0 : 1 );
            alpha.reserve(alpha_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < alpha_d_0_max__; ++d_0__) {
                if (jacobian__)
                    alpha.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    alpha.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 170;
            std::vector<local_scalar_t__> gamma;
            size_t gamma_d_0_max__ = (logical_eq(is_gamma, 0) ? 0 : 1 );
            gamma.reserve(gamma_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < gamma_d_0_max__; ++d_0__) {
                if (jacobian__)
                    gamma.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    gamma.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 171;
            std::vector<local_scalar_t__> lambda;
            size_t lambda_d_0_max__ = (logical_eq(is_lambda, 0) ? 0 : 1 );
            lambda.reserve(lambda_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < lambda_d_0_max__; ++d_0__) {
                if (jacobian__)
                    lambda.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    lambda.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 172;
            std::vector<local_scalar_t__> mu;
            size_t mu_d_0_max__ = (logical_eq(is_mu, 0) ? 0 : 1 );
            mu.reserve(mu_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < mu_d_0_max__; ++d_0__) {
                if (jacobian__)
                    mu.push_back(in__.scalar_constrain(lp__));
                else
                    mu.push_back(in__.scalar_constrain());
            }
            current_statement_begin__ = 173;
            std::vector<local_scalar_t__> sigma;
            size_t sigma_d_0_max__ = (logical_eq(is_sigma, 0) ? 0 : 1 );
            sigma.reserve(sigma_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < sigma_d_0_max__; ++d_0__) {
                if (jacobian__)
                    sigma.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    sigma.push_back(in__.scalar_lb_constrain(0));
            }
            // model body
            {
            current_statement_begin__ = 179;
            validate_non_negative_index("lp", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lp(n);
            stan::math::initialize(lp, DUMMY_VAR__);
            stan::math::fill(lp, DUMMY_VAR__);
            current_statement_begin__ = 180;
            validate_non_negative_index("y", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> y(n);
            stan::math::initialize(y, DUMMY_VAR__);
            stan::math::fill(y, DUMMY_VAR__);
            current_statement_begin__ = 181;
            validate_non_negative_index("loglik", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> loglik(n);
            stan::math::initialize(loglik, DUMMY_VAR__);
            stan::math::fill(loglik, DUMMY_VAR__);
            current_statement_begin__ = 182;
            validate_non_negative_index("lpdf", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lpdf(n);
            stan::math::initialize(lpdf, DUMMY_VAR__);
            stan::math::fill(lpdf, DUMMY_VAR__);
            current_statement_begin__ = 183;
            validate_non_negative_index("lsurv", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lsurv(n);
            stan::math::initialize(lsurv, DUMMY_VAR__);
            stan::math::fill(lsurv, DUMMY_VAR__);
            current_statement_begin__ = 184;
            validate_non_negative_index("lp_long", "(logical_eq(survreg, 5) ? n : 0 )", (logical_eq(survreg, 5) ? n : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lp_long((logical_eq(survreg, 5) ? n : 0 ));
            stan::math::initialize(lp_long, DUMMY_VAR__);
            stan::math::fill(lp_long, DUMMY_VAR__);
            current_statement_begin__ = 185;
            validate_non_negative_index("ratio", "(logical_eq(survreg, 5) ? n : 0 )", (logical_eq(survreg, 5) ? n : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ratio((logical_eq(survreg, 5) ? n : 0 ));
            stan::math::initialize(ratio, DUMMY_VAR__);
            stan::math::fill(ratio, DUMMY_VAR__);
            current_statement_begin__ = 187;
            if (as_bool(logical_gt(p, 0))) {
                current_statement_begin__ = 188;
                stan::math::assign(lp, multiply(X, beta));
            } else {
                current_statement_begin__ = 190;
                stan::math::assign(lp, zeros);
            }
            current_statement_begin__ = 193;
            if (as_bool(logical_eq(survreg, 1))) {
                current_statement_begin__ = 194;
                stan::math::assign(y, elt_divide(time, stan::math::exp(lp)));
            } else if (as_bool(logical_eq(survreg, 4))) {
                current_statement_begin__ = 196;
                stan::math::assign(y, elt_multiply(time, stan::math::exp(lp)));
            } else {
                current_statement_begin__ = 198;
                stan::math::assign(y, time);
            }
            current_statement_begin__ = 203;
            if (as_bool(logical_eq(baseline, 1))) {
                current_statement_begin__ = 204;
                for (int i = 1; i <= n; ++i) {
                    current_statement_begin__ = 205;
                    stan::model::assign(lpdf, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                exponential_log(get_base1(y, i, "y", 1), lambda), 
                                "assigning variable lpdf");
                    current_statement_begin__ = 206;
                    stan::model::assign(lsurv, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                exponential_ccdf_log(get_base1(y, i, "y", 1), lambda), 
                                "assigning variable lsurv");
                }
            } else if (as_bool(logical_eq(baseline, 2))) {
                current_statement_begin__ = 209;
                for (int i = 1; i <= n; ++i) {
                    current_statement_begin__ = 210;
                    stan::model::assign(lpdf, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                weibull_log(get_base1(y, i, "y", 1), alpha, gamma), 
                                "assigning variable lpdf");
                    current_statement_begin__ = 211;
                    stan::model::assign(lsurv, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                weibull_ccdf_log(get_base1(y, i, "y", 1), alpha, gamma), 
                                "assigning variable lsurv");
                }
            } else if (as_bool(logical_eq(baseline, 3))) {
                current_statement_begin__ = 214;
                for (int i = 1; i <= n; ++i) {
                    current_statement_begin__ = 215;
                    stan::model::assign(lpdf, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                lognormal_log(get_base1(y, i, "y", 1), mu, sigma), 
                                "assigning variable lpdf");
                    current_statement_begin__ = 216;
                    stan::model::assign(lsurv, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                lognormal_ccdf_log(get_base1(y, i, "y", 1), mu, sigma), 
                                "assigning variable lsurv");
                }
            } else if (as_bool(logical_eq(baseline, 4))) {
                current_statement_begin__ = 219;
                for (int i = 1; i <= n; ++i) {
                    current_statement_begin__ = 220;
                    stan::model::assign(lpdf, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                loglogistic_lpdf(get_base1(y, i, "y", 1), get_base1(alpha, 1, "alpha", 1), get_base1(gamma, 1, "gamma", 1), pstream__), 
                                "assigning variable lpdf");
                    current_statement_begin__ = 221;
                    stan::model::assign(lsurv, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                loglogistic_lccdf(get_base1(y, i, "y", 1), get_base1(alpha, 1, "alpha", 1), get_base1(gamma, 1, "gamma", 1), pstream__), 
                                "assigning variable lsurv");
                }
            } else if (as_bool(logical_eq(baseline, 5))) {
                current_statement_begin__ = 224;
                for (int i = 1; i <= n; ++i) {
                    current_statement_begin__ = 225;
                    stan::model::assign(lpdf, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                fatigue_lpdf(get_base1(y, i, "y", 1), get_base1(alpha, 1, "alpha", 1), get_base1(gamma, 1, "gamma", 1), pstream__), 
                                "assigning variable lpdf");
                    current_statement_begin__ = 226;
                    stan::model::assign(lsurv, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                fatigue_lccdf(get_base1(y, i, "y", 1), get_base1(alpha, 1, "alpha", 1), get_base1(gamma, 1, "gamma", 1), pstream__), 
                                "assigning variable lsurv");
                }
            }
            current_statement_begin__ = 230;
            if (as_bool(logical_eq(survreg, 1))) {
                current_statement_begin__ = 231;
                stan::math::assign(loglik, loglik_aft(lpdf, lsurv, event, lp, tau, pstream__));
            } else if (as_bool(logical_eq(survreg, 2))) {
                current_statement_begin__ = 233;
                stan::math::assign(loglik, loglik_ph(lpdf, lsurv, event, lp, tau, pstream__));
            } else if (as_bool(logical_eq(survreg, 3))) {
                current_statement_begin__ = 235;
                stan::math::assign(loglik, loglik_po(lpdf, lsurv, event, lp, tau, pstream__));
            } else if (as_bool(logical_eq(survreg, 4))) {
                current_statement_begin__ = 237;
                stan::math::assign(loglik, loglik_ah(lpdf, lsurv, event, lp, tau, pstream__));
            } else {
                current_statement_begin__ = 239;
                if (as_bool(logical_gt(p, 0))) {
                    current_statement_begin__ = 240;
                    stan::math::assign(lp_long, multiply(X, phi));
                } else {
                    current_statement_begin__ = 242;
                    stan::math::assign(lp_long, zeros);
                }
                current_statement_begin__ = 244;
                stan::math::assign(ratio, stan::math::exp(multiply(X, subtract(beta, phi))));
                current_statement_begin__ = 245;
                stan::math::assign(loglik, loglik_yp(event, lpdf, lsurv, lp, lp_long, ratio, tau, pstream__));
            }
            current_statement_begin__ = 248;
            lp_accum__.add(sum(loglik));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta");
        names__.push_back("phi");
        names__.push_back("alpha");
        names__.push_back("gamma");
        names__.push_back("lambda");
        names__.push_back("mu");
        names__.push_back("sigma");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back((logical_eq(p, 0) ? 0 : p ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(is_phi, 0) ? 0 : p ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(is_alpha, 0) ? 0 : 1 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(is_gamma, 0) ? 0 : 1 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(is_lambda, 0) ? 0 : 1 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(is_mu, 0) ? 0 : 1 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(is_sigma, 0) ? 0 : 1 ));
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_survreg_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta = in__.vector_constrain((logical_eq(p, 0) ? 0 : p ));
        size_t beta_j_1_max__ = (logical_eq(p, 0) ? 0 : p );
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            vars__.push_back(beta(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> phi = in__.vector_constrain((logical_eq(is_phi, 0) ? 0 : p ));
        size_t phi_j_1_max__ = (logical_eq(is_phi, 0) ? 0 : p );
        for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
            vars__.push_back(phi(j_1__));
        }
        std::vector<double> alpha;
        size_t alpha_d_0_max__ = (logical_eq(is_alpha, 0) ? 0 : 1 );
        alpha.reserve(alpha_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < alpha_d_0_max__; ++d_0__) {
            alpha.push_back(in__.scalar_lb_constrain(0));
        }
        size_t alpha_k_0_max__ = (logical_eq(is_alpha, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
            vars__.push_back(alpha[k_0__]);
        }
        std::vector<double> gamma;
        size_t gamma_d_0_max__ = (logical_eq(is_gamma, 0) ? 0 : 1 );
        gamma.reserve(gamma_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < gamma_d_0_max__; ++d_0__) {
            gamma.push_back(in__.scalar_lb_constrain(0));
        }
        size_t gamma_k_0_max__ = (logical_eq(is_gamma, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < gamma_k_0_max__; ++k_0__) {
            vars__.push_back(gamma[k_0__]);
        }
        std::vector<double> lambda;
        size_t lambda_d_0_max__ = (logical_eq(is_lambda, 0) ? 0 : 1 );
        lambda.reserve(lambda_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < lambda_d_0_max__; ++d_0__) {
            lambda.push_back(in__.scalar_lb_constrain(0));
        }
        size_t lambda_k_0_max__ = (logical_eq(is_lambda, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < lambda_k_0_max__; ++k_0__) {
            vars__.push_back(lambda[k_0__]);
        }
        std::vector<double> mu;
        size_t mu_d_0_max__ = (logical_eq(is_mu, 0) ? 0 : 1 );
        mu.reserve(mu_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < mu_d_0_max__; ++d_0__) {
            mu.push_back(in__.scalar_constrain());
        }
        size_t mu_k_0_max__ = (logical_eq(is_mu, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
            vars__.push_back(mu[k_0__]);
        }
        std::vector<double> sigma;
        size_t sigma_d_0_max__ = (logical_eq(is_sigma, 0) ? 0 : 1 );
        sigma.reserve(sigma_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < sigma_d_0_max__; ++d_0__) {
            sigma.push_back(in__.scalar_lb_constrain(0));
        }
        size_t sigma_k_0_max__ = (logical_eq(is_sigma, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            if (!include_gqs__ && !include_tparams__) return;
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_survreg";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta_j_1_max__ = (logical_eq(p, 0) ? 0 : p );
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t phi_j_1_max__ = (logical_eq(is_phi, 0) ? 0 : p );
        for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t alpha_k_0_max__ = (logical_eq(is_alpha, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma_k_0_max__ = (logical_eq(is_gamma, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < gamma_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_k_0_max__ = (logical_eq(is_lambda, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < lambda_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t mu_k_0_max__ = (logical_eq(is_mu, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_k_0_max__ = (logical_eq(is_sigma, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta_j_1_max__ = (logical_eq(p, 0) ? 0 : p );
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t phi_j_1_max__ = (logical_eq(is_phi, 0) ? 0 : p );
        for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t alpha_k_0_max__ = (logical_eq(is_alpha, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma_k_0_max__ = (logical_eq(is_gamma, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < gamma_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_k_0_max__ = (logical_eq(is_lambda, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < lambda_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t mu_k_0_max__ = (logical_eq(is_mu, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_k_0_max__ = (logical_eq(is_sigma, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_survreg_namespace::model_survreg stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
