% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_pycox.R
\name{build_pytorch_net}
\alias{build_pytorch_net}
\title{Build a Pytorch Multilayer Perceptron}
\usage{
build_pytorch_net(
  n_in,
  n_out,
  nodes = c(32, 32),
  activation = "relu",
  act_pars = list(),
  dropout = 0.1,
  bias = TRUE,
  batch_norm = TRUE,
  batch_pars = list(eps = 1e-05, momentum = 0.1, affine = TRUE),
  init = "uniform",
  init_pars = list()
)
}
\arguments{
\item{n_in}{\code{(integer(1))}\cr Number of input features.}

\item{n_out}{\code{(integer(1))}\cr Number of targets.}

\item{nodes}{\code{(numeric())}\cr Hidden nodes in network, each element in vector represents number
of hidden nodes in respective layer.}

\item{activation}{\code{(character(1)|list())}\cr Activation function, can either be a single
character and the same function is used in all layers, or a list of length \code{length(nodes)}. See
\link{get_pycox_activation} for options.}

\item{act_pars}{\code{(list())}\cr Passed to \link{get_pycox_activation}.}

\item{dropout}{\code{(numeric())}\cr Optional dropout layer, if \code{NULL} then no dropout layer added
otherwise either a single numeric which will be added to all layers or a vector of differing
drop-out amounts.}

\item{bias}{\code{(logical(1))}\cr If \code{TRUE} (default) then a bias parameter is added to all linear
layers.}

\item{batch_norm}{\code{(logical(1))}\cr If \code{TRUE} (default) then batch normalisation is applied
to all layers.}

\item{batch_pars}{\code{(list())}\cr Parameters for batch normalisation, see
\code{reticulate::py_help(torch$nn$BatchNorm1d)}.}

\item{init}{\code{(character(1))}\cr Weight initialization method. See
\link{get_pycox_init} for options.}

\item{init_pars}{\code{(list())}\cr Passed to \link{get_pycox_init}.}
}
\description{
Utility function to build an MLP with a choice of activation function and weight
initialization with optional dropout and batch normalization.
}
\details{
This function is a helper for R users with less Python experience. Currently it is
limited to simple MLPs. More advanced networks will require manual creation with
\CRANpkg{reticulate}.
}
\examples{
\donttest{
if (requireNamespaces("reticulate")) {
  build_pytorch_net(4L, 2L, nodes = c(32, 64, 32), activation = "selu")

  # pass parameters to activation and initializer functions
  build_pytorch_net(4L, 2L, activation = "elu", act_pars = list(alpha = 0.1),
  init  = "kaiming_uniform", init_pars = list(mode = "fan_out"))
}
}

}
