% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDMdf.R
\name{LDMdf}
\alias{LDMdf}
\title{Landmark estimator for the bivariate distribution function}
\usage{
LDMdf(object, x, y)
}
\arguments{
\item{object}{An object of class multidf.}

\item{x}{The first time for obtaining estimates for the bivariate distribution
function.}

\item{y}{The second time for obtaining estimates for the bivariate 
distribution function.}
}
\value{
Vector with the Landmark estimates for the bivariate distribution 
function.
}
\description{
Provides estimates for the bivariate distribution function based 
on Bayes' theorem and Kaplan-Meier survival function. This approach is also
named as landmarking.
}
\examples{

b3state<-multidf(gap1=bladder4state$y1, event1=bladder4state$d1, 
                 gap2=bladder4state$y2, status=bladder4state$d2, 
                 size=bladder4state$size)
                 
LDMdf(b3state, x=13, y=20)

}
\references{
van Houwelingen, H.C. (2007). Dynamic prediction by landmarking in
event history analysis, Scandinavian Journal of Statistics, 34, 70-85.

Kaplan, E. and Meier, P. (1958). Nonparametric Estimation from Incomplete 
Observations, Journal of the American Statistical Association 53(282), 
457-481.
}
\seealso{
\code{\link{IPCWdf}}, \code{\link{KMWdf}}, \code{\link{LINdf}} 
and \code{\link{WCHdf}}.
}
\author{
Gustavo Soutinho and Luis Meira-Machado
}
