% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_rate.R
\name{tab_rate}
\alias{tab_rate}
\title{Calculate rates}
\usage{
tab_rate(
  vr,
  pop,
  per = getOption("surveytable.rate_per"),
  drop_na = getOption("surveytable.drop_na"),
  max_levels = getOption("surveytable.max_levels"),
  csv = getOption("surveytable.csv")
)
}
\arguments{
\item{vr}{variable to tabulate}

\item{pop}{either a single number or a \code{data.frame} with columns named
\code{Level} and \code{Population}. \code{Level} must
exactly match the levels of \code{vr}. \code{Population} is the population for that
level of \code{vr}.}

\item{per}{calculate rate per this many items in the population}

\item{drop_na}{drop missing values (\code{NA})?}

\item{max_levels}{a categorical variable can have at most this many levels. Used to avoid printing huge tables.}

\item{csv}{name of a CSV file}
}
\value{
A list of tables or a single table.
}
\description{
Calculate the rates for categorical (factor) or logical variables.
}
\examples{
set_survey(namcs2019sv)
# pop is a data frame
tab_rate("MSA", uspop2019$MSA)

# pop is a single number
tab_rate("MDDO", uspop2019$total)
}
\seealso{
Other tables: 
\code{\link{tab_cross}()},
\code{\link{tab_subset_rate}()},
\code{\link{tab}()},
\code{\link{total_rate}()},
\code{\link{total}()}
}
\concept{tables}
