% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_surv_ceteris_paribus.R
\name{plot.surv_ceteris_paribus}
\alias{plot.surv_ceteris_paribus}
\title{Plot Predict Profile for Survival Models}
\usage{
\method{plot}{surv_ceteris_paribus}(
  x,
  ...,
  colors = NULL,
  variable_type = NULL,
  facet_ncol = NULL,
  variables = NULL,
  numerical_plot_type = "lines",
  title = "Ceteris paribus survival profile",
  subtitle = "default"
)
}
\arguments{
\item{x}{an object of class \code{predict_profile_survival} to be plotted}

\item{...}{additional parameters, unused, currently ignored}

\item{colors}{character vector containing the colors to be used for plotting variables (containing either hex codes "#FF69B4", or names "blue")}

\item{variable_type}{character, either \code{"numerical"}, \code{"categorical"} or \code{NULL} (default), select only one type of variable for plotting, or leave \code{NULL} for all}

\item{facet_ncol}{number of columns for arranging subplots}

\item{variables}{character, names of the variables to be plotted}

\item{numerical_plot_type}{character, either \code{"lines"}, or \code{"contours"} selects the type of numerical variable plots}

\item{title}{character, title of the plot}

\item{subtitle}{character, subtitle of the plot, \code{'default'} automatically generates "created for XXX, YYY models", where XXX and YYY are the explainer labels}
}
\value{
A grid of \code{ggplot} objects arranged with the \code{gridExtra::grid.arrange} function.
}
\description{
This function plots objects of class \code{"predict_profile_survival"} created using
the \code{predict_profile()} function.
}
\examples{
\donttest{
library(survival)
library(survex)

model <- randomForestSRC::rfsrc(Surv(time, status) ~ ., data = veteran)
exp <- explain(model)

p_profile <- predict_profile(exp, veteran[1, -c(3, 4)])

plot(p_profile)

p_profile_with_cat <- predict_profile(
    exp,
    veteran[1, -c(3, 4)],
    categorical_variables = c("trt", "prior")
)

plot(p_profile_with_cat)
}

}
\seealso{
Other functions for plotting 'predict_profile_survival' objects: 
\code{\link{plot.predict_profile_survival}()}
}
\concept{functions for plotting 'predict_profile_survival' objects}
