% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPenV1_2.r
\name{design.matrix}
\alias{design.matrix}
\title{Design matrix for the model needed in Gauss-Legendre quadrature}
\usage{
design.matrix(formula, data.spec, Z.smf, Z.tensor, Z.tint, list.smf,
  list.tensor, list.tint, list.rd)
}
\arguments{
\item{formula}{formula object identifying the model}

\item{data.spec}{data frame that represents the environment from which the covariate values and knots are to be calculated}

\item{Z.smf}{List of matrices that represents the sum-to-zero constraint to apply for \code{\link{smf}} splines}

\item{Z.tensor}{List of matrices that represents the sum-to-zero constraint to apply for \code{\link{tensor}} splines}

\item{Z.tint}{List of matrices that represents the sum-to-zero constraint to apply for \code{\link{tint}} splines}

\item{list.smf}{List of all smf.smooth.spec objects contained in the model}

\item{list.tensor}{List of all tensor.smooth.spec objects contained in the model}

\item{list.tint}{List of all tint.smooth.spec objects contained in the model}

\item{list.rd}{List of all rd.smooth.spec objects contained in the model}
}
\value{
design matrix for the model
}
\description{
Builds the design matrix for the whole model when the sum-to-zero constraints are specified. The function is called inside \code{\link{model.cons}}
for Gauss-Legendre quadrature.
}
\examples{

library(survPen)

# standard spline of time with 4 knots

data <- data.frame(time=seq(0,5,length=100),event=1,t0=0)

form <- ~ smf(time,knots=c(0,1,3,5))

t1 <- eval(substitute(time), data)
t0 <- eval(substitute(t0), data)
event <- eval(substitute(event), data)
	
# Setting up the model
model.c <- model.cons(form,lambda=0,data.spec=data,t1=t1,t1.name="time",
t0=rep(0,100),t0.name="t0",event=event,event.name="event",
expected=NULL,expected.name=NULL,type="overall",n.legendre=20,
cl="survPen(form,data,t1=time,event=event)")
 
# Retrieving the sum-to-zero constraint matrices and the list of knots
Z.smf <- model.c$Z.smf ; list.smf <- model.c$list.smf

# Calculating the design matrix
design.M <- design.matrix(form,data.spec=data,Z.smf=Z.smf,list.smf=list.smf,
Z.tensor=NULL,Z.tint=NULL,list.tensor=NULL,list.tint=NULL,list.rd=NULL)

}
