% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plotSurv}
\alias{plot.Surv}
\alias{plotSurv}
\title{Plot a \code{Surv} object.}
\usage{
\method{plot}{Surv}(x, l = 3, ...)
}
\arguments{
\item{x}{A \code{Surv} object}

\item{l}{length of arrow. Length is \code{l / nrow(x)}}

\item{...}{Additional arguments.
 \cr
These are passed to as \code{...} (an ellipsis) to the following functions, respectively:
\describe{
 \item{\code{graphics::arrows}}{for plotting right- or left-censored observations}
 \item{\code{graphics::segments}}{for plotting interval-censored observations}
}}
}
\value{
A graph (base graphics).
The type of graph depends on the \code{type} of the \code{Surv} object.
This is given by \code{attr(s, which="type")} :
 \item{counting}{Lines with an arrow pointing right if right censored.}
 \item{right}{Lines with an arrow pointing right if right censored.}
 \item{left}{Lines with an arrow pointing left if left censored.}
 \item{interval}{If censored:
  \describe{
   \item{arrow points right}{right censored}
   \item{arrow points left}{left censored}
  }
  If not censored:
   \describe{
    \item{lines}{observations of more than one time point}
    \item{points}{observation of one time only (i.e. start and end times are the same)}
   }
 }
}
\description{
Plot a \code{Surv} object.
}
\examples{
df0 <- data.frame(t1=c(0, 2, 4, 6, NA, NA, 12, 14),
                  t2=c(NA, NA, 4, 6, 8, 10, 16, 18))
s5 <- Surv(df0$t1, df0$t2, type="interval2")
plot(s5)
}
\seealso{
?graphics::arrows

?graphics::segments
}
\keyword{plot}

