% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyflow.R
\name{svyflow}
\alias{svyflow}
\alias{svyflow.survey.design2}
\alias{svyflow.svyrep.design}
\title{Gross flow estimation between categories}
\usage{
\method{svyflow}{survey.design2}(
  x,
  design,
  model = c("A", "B", "C", "D"),
  tol = 1e-04,
  maxit = 5000,
  verbose = FALSE,
  as.zero.flows = FALSE,
  influence = FALSE,
  ...
)

\method{svyflow}{svyrep.design}(
  x,
  design,
  model = c("A", "B", "C", "D"),
  tol = 1e-04,
  maxit = 5000,
  verbose = FALSE,
  as.zero.flows = FALSE,
  influence = FALSE,
  ...
)
}
\arguments{
\item{x}{a one-sided formula indicating a \emph{factor} variable.}

\item{design}{survey design object}

\item{model}{Stasny (1987) model for the non-response process. Possibilities: \code{"A", "B", "C", "D"}. Defaults to \code{model = "A"}.}

\item{tol}{Tolerance for iterative proportional fitting. Defaults to \code{1e-4}.}

\item{maxit}{Maximum number of iterations for iterative proportional fitting. Defaults to \code{maxit = 5000}.}

\item{verbose}{Print proportional fitting iterations. Defaults to \code{verbose = FALSE}.}

\item{as.zero.flows}{Should zeroes in the observed gross flows should be considered as zeroes in the population transition probability matrix? Defaults to \code{as.zero.flows = FALSE}.}

\item{influence}{Should influence functions estimates be stored? Defaults to \code{influence = FALSE}.}

\item{...}{future expansion.}
}
\value{
Objects of class \code{flowstat}, a list of \code{svystat} and \code{svymstat} (a matrix version of \code{svystat}) objects.
The \code{flowstat} object contais estimates of: the initial response probababilities \code{psi}, the response/response transition probabilities \code{rho},
the non-response/non-response transition probabilities \code{tau}, the (non-response corrected) initial and final distributions across categories \code{eta} and \code{gamma},
the (non-response corrected) transition probability matrix \code{pij}, the (non-response corrected) gross flows matrix \code{muij}, and the vector of net flows \code{delta}.
These objects have methods for coef, vcov, SE, and cv.

A Rao-Scott Corrected Chi^2 test is also calculated.
}
\description{
Compute gross flows for data from complex surveys with repeated samples.
}
\details{
It is important to distinguish "missing" responses from "unnaplicable" responses. This is feasible by subsetting the design
for only applicable responses (with actual missing responses, if that is the case). For instance, suppose that we have two variables encoded as
employed/unemployed, with NAs if the response is missing or is unnaplicable. An \code{NA} might be a person that did not respond \emph{or} a person
who was under the working-age at the time of the survey. It is important to distinguish across those, as only one of those cases is an
actual non-response. You could do that by looking for people who were in working age in any round, for instance. This can be done by using \code{subset},
as you should for a \code{survey design} object.
}
\examples{

# load library
library( survey )
library( surf )

# load data
data( "LFS79.0809" )

# create surf design object
lfs.des <- svydesign( ids = ~0 , probs = ~ prob , data = LFS79.0809 , nest = TRUE )

# flow estimates
estflows <- svyflow( ~y1+y2 , design = lfs.des )
coef( estflows$muij )
SE( estflows$muij )

}
\references{
STASNY, E. A. Some Markov-chain models for nonresponse in estimating gross labor force flows. \emph{Journal of Official Statistics}, v. 3, n. 4, p. 359, 1987.

GUTIERREZ, H. A.; TRUJILLO, L.; SILVA, P. L. N. The estimation of gross flows in complex surveys with random nonresponse.
\emph{Survey Methodology}, v. 40, n. 2, p. 285–321, dec. 2014. URL \url{https://www150.statcan.gc.ca/n1/en/catalogue/12-001-X201400214113}.

LUMLEY, T. \emph{Complex Surveys:} A guide to analysis using R.
Hoboken: John Wiley & Sons, 2010. (Wiley Series in Survey Methodology). ISBN 978-0-470-28430-8.
}
\author{
Guilherme Jacob
}
