#' @title Artificial 1979 Aug-Sep Canadian LFS dataset
#'
#' @description Artificial dataset based on Stasny (1987) LFS counts for the 1979 August-September flows.
#'
#' @docType data
#'
#' @usage data("LFS79.0809")
#'
#' @format A data frame with three columns: \code{y1} and \code{y2} describing
#' individual job status ( \code{E} = "Employed"; \code{U}; "Unemployed"; \code{N} = "Not in the labor force") in each month,
#' and a vector of selection probailities \code{probs}.
#'
#' @references STASNY, E. A. Some Markov-chain models for nonresponse in estimating gross labor force flows. \emph{Journal of Official Statistics}, v. 3, n. 4, p. 359, 1987.
#'
#' @keywords real
"LFS79.0809"

#' @title Artificial 1979 Sep-Oct LFS dataset
#'
#' @description Artificial dataset based on Stasny (1987) LFS counts for the 1979 September-October flows.
#'
#' @docType data
#'
#' @usage data("LFS79.0910")
#'
#' @format A data frame with three columns: \code{y1} and \code{y2} describing
#' individual job status ( \code{E} = "Employed"; \code{U}; "Unemployed"; \code{N} = "Not in the labor force") in each month,
#' and a vector of selection probailities \code{probs}.
#'
#' @references STASNY, E. A. Some Markov-chain models for nonresponse in estimating gross labor force flows. \emph{Journal of Official Statistics}, v. 3, n. 4, p. 359, 1987.
#'
#' @keywords real
"LFS79.0910"
