% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ic_tbl}
\alias{ic_tbl}
\title{Helper function to create a model comparison table}
\usage{
ic_tbl(..., sort_by = c("AIC", "BIC", "none"))
}
\arguments{
\item{...}{\link{dots} One or more model fit results from
\code{\link[fitdistrplus:fitdist]{fitdistrplus::fitdist()}}.}

\item{sort_by}{A \code{character} string specifying which information criterion
to order the table by, either \code{"AIC"} (default), \code{"BIC"}, or \code{"none"}
(i.e. no ordering).}
}
\value{
A \verb{<data.frame>}.
}
\description{
This is a helper function for creating a model comparison
\verb{<data.frame>} primarily for use in the \pkg{superspreading} vignettes. It
is designed specifically for handling \code{\link[fitdistrplus:fitdist]{fitdistrplus::fitdist()}} output and
not a generalised function. See \code{bbmle::ICtab()} for a more general use
function to create information criteria tables.
}
\examples{
if (requireNamespace("fitdistrplus", quietly = TRUE)) {
  cases <- rnbinom(n = 100, mu = 5, size = 0.7)
  pois_fit <- fitdistrplus::fitdist(data = cases, distr = "pois")
  geom_fit <- fitdistrplus::fitdist(data = cases, distr = "geom")
  nbinom_fit <- fitdistrplus::fitdist(data = cases, distr = "nbinom")
  ic_tbl(pois_fit, geom_fit, nbinom_fit)
}
}
