#' cla_train
#'
#' Training Dataset used for classification examples. This is classic titanic dataset used to predict
#' if a passenger will survive or not in titanic ship disaster.
#'
#' @format A data frame with 12 variables:
#' \describe{
#' \item{\code{PassengerId}}{unique ID of the passenger}
#' \item{\code{Survived}}{survival of the passenger}
#' \item{\code{Pclass}}{ticket class}
#' \item{\code{Name}}{name of the passenger}
#' \item{\code{Sex}}{sex of the passenger}
#' \item{\code{Age}}{Age of the passenger}
#' \item{\code{SibSp}}{number of siblings/spouse aboard the titanic}
#' \item{\code{Parch}}{number of parents / child aboard the titanic}
#' \item{\code{Ticket}}{ticket number}
#' \item{\code{Fare}}{passenger fare}
#' \item{\code{Cabin}}{cabin number}
#' \item{\code{Embarked}}{port of embarkation}
#' }
#'
#' For further details, see \url{https://www.kaggle.com/c/titanic/data}
#'
"cla_train"


#' reg_train
#'
#' Training Dataset used for regression examples. In this data set, we have to predict
#' the sale price of the houses.
#'
#' @format A data frame with 81 variables
#' \describe{
#' \item{\code{SalePrice}}{the property's sale price in dollars. This is the target variable that you're trying to predict.}
#'
#' For further details, see \url{https://www.kaggle.com/c/house-prices-advanced-regression-techniques/data}
#'
"reg_train"




