% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superbToWide.R
\name{superbToWide}
\alias{superbToWide}
\title{superbToWide: Reshape long data frame to wide, suitable for superbPlot}
\usage{
superbToWide(
  data,
  id = NULL,
  BSFactors = NULL,
  WSFactors = NULL,
  variable = NULL
)
}
\arguments{
\item{data}{Dataframe in long format}

\item{id}{A column with unique identifiers per subject}

\item{BSFactors}{The name(s) of the between-subject factor(s) as string(s)}

\item{WSFactors}{The name(s) of the within-subject factor(s) as string(s)}

\item{variable}{The dependent variable as string}
}
\value{
A wide-format data frame ready for superbPlot() or superbData(). All other variables will be erased.
}
\description{
The function \code{suberbToWide()} is an extension to Navarro's WideToLong function
with ample checks to make sure all is legit, so that the data
is suitably organized for \code{suberb}. See \insertCite{cgh21}{superb} for more.
Other techniques are available to transform long to wide, but many asked for it within \code{superb}.
}
\examples{
library(ggplot2)
library(gridExtra)

# Example using the built-in dataframe Orange. 
data(Orange)
superbToWide(Orange, id = "Tree", WSFactors = c("age"), variable = "circumference") 

# Optional: change column names to shorten "circumference" to "DV"
names(Orange) <- c("Tree","age","DV")
# turn the data into a wide format
Orange.wide <- superbToWide(Orange, id = "Tree", WSFactors = c("age"), variable = "DV") 

# Makes the plots two different way:
p1=superbPlot( Orange.wide, WSFactors = "age(7)",
  variables = c("DV.118","DV.484","DV.664","DV.1004","DV.1231","DV.1372","DV.1582"),
  adjustments = list(purpose = "difference", decorrelation = "none")
) + 
  xlab("Age level") + ylab("Trunk diameter (mm)") +
  coord_cartesian( ylim = c(0,250) ) + labs(title="Basic confidence intervals")

p2=superbPlot( Orange.wide, WSFactors = "age(7)",
  variables = c("DV.118","DV.484","DV.664","DV.1004","DV.1231","DV.1372","DV.1582"),
  adjustments = list(purpose = "difference", decorrelation = "CA")
) + 
  xlab("Age level") + ylab("Trunk diameter (mm)") +
  coord_cartesian( ylim = c(0,250) ) + labs(title="Decorrelated confidence intervals")
grid.arrange(p1,p2,ncol=2)

# Note that with superb(), there is no need to reformat
# into a wide format anymore:
superb( DV ~ age | Tree, Orange )


}
\references{
\insertAllCited{}
}
