% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d2b.R
\name{sund2b}
\alias{sund2b}
\title{Sunburst Using 'd2b'}
\usage{
sund2b(data = NULL, colors = NULL, valueField = "size",
  tooltip = NULL, width = NULL, height = NULL, elementId = NULL)
}
\arguments{
\item{data}{data in csv source,target form or in
nested d3 JSON hierarchy with `{name:...,  children:[];}`.  \code{list}, \code{character},
or \code{connection} data will be assumed to be \code{JSON}.
\code{data.frame} data will be assumed to be \code{csvdata} and converted
to \code{JSON} by \code{sunburstR:::csv_to_hier()}.}

\item{colors}{\code{vector} of strings representing colors as hexadecimal for
manual colors.  If you want precise control of colors, supply a \code{list}
with \code{range} and/or \code{domain}. For advanced customization, supply
a JavaScript \code{function}.}

\item{valueField}{\code{character} for the field to use to calculate size.  The default
value is \code{"size"}.}

\item{tooltip}{\code{list} of options for customizing the tooltip. See the helper
function \code{\link{sund2bTooltip}} for more information.}

\item{height, width}{height and width of sunburst htmlwidget containing div
specified in any valid \code{CSS} size unit.}

\item{elementId}{string id as a valid \code{CSS} element id.}
}
\description{
Create interactive sunburst chart with the 'd2b' charting library.
}
\examples{
\dontrun{

# The sund2b() API mirrors sunburst() with fewer arguments.

library(sunburstR)

# use a sample of the sequences csv data
sequences <- read.csv(
  system.file("examples/visit-sequences.csv",package="sunburstR")
  ,header = FALSE
  ,stringsAsFactors = FALSE
)[1:200,]

# create a d2b sunburst
sund2b(sequences)

# change the colors
#   using d3.js categorical color scheme
sund2b(
  sequences,
  colors = htmlwidgets::JS("d3.scaleOrdinal(d3.schemeCategory20b)")
)
#  using RColorBrewer palette
sund2b(
  sequences,
  colors = list(range = RColorBrewer::brewer.pal(9, "Set3"))
)
#  using a color column from the R dataset
#  treemap has an amazing treecolors ability
library(treemap)
library(d3r)
rhd <- random.hierarchical.data()
tm <- treemap(
  rhd,
  index = paste0("index", 1:3),
  vSize = "x",
  draw = FALSE
)$tm
sund2b(
  d3_nest(tm, value_cols = colnames(tm)[-(1:3)]),
  colors = htmlwidgets::JS(
    # yes this is a little different, so please pay attention
    #  "function(d) {return d.color}" will not work
    "function(name, d){return d.color || '#ccc';}"
  ),
  valueField = "vSize"
)


# use sund2b in Shiny
library(shiny)
ui <- sund2bOutput("sun")
server <- function(input, output, session) {
  output$sun <- renderSund2b({
    sund2b(sequences)
  })
}
shinyApp(ui, server)

}
}
