% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarytools.R
\docType{package}
\name{summarytools-package}
\alias{summarytools}
\alias{summarytools-package}
\title{Extensive Summarizing Tools With Flexible Output}
\description{
\pkg{summarytools} provides users with functions to neatly and quickly
summarize numerical and categorical data. Data frame summaries, frequency
tables and cross-tabulations, as well as common univariate statistics can be
produced in a straightforward manner. Users with little to no prior R
programming experience but who are familiar with the concepts (and maybe with
some procedures coming from other software packages) should find their way
easily.
}
\details{
These are the four core functions: 
\describe{
  \item{dfSummary}{Extensive yet legible data frame summaries.}
  \item{freq}{Frequency tables supporting weights and displaying proportions
  of valid and of total data, including cumulative proportions.}
  \item{descr}{All common univariate descriptive stats for single vectors
     or for all numerical vectors in a data frame.}
  \item{ctable}{Cross-tabulations for two categorical vectors or factors.
    Choose between \emph{Total}, \emph{Columns} or \emph{Rows} proportions.}
}

\strong{Output formats} are:
 \describe{
   \item{plain ascii}{Ideal when looking at results in the console.}
   \item{rmarkdown}{Ideal when writing short papers or presentations.}
   \item{html}{This format is well integrated in RStudio (but will
   work with any browser). Use the \code{view()} function to see results
   appear directly in RStudio’s Viewer or in your default Web
   Browser.}
 }
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/dcomtois/summarytools}
  \item Report bugs at \url{https://github.com/dcomtois/summarytools/issues}
}

}
\author{
\strong{Maintainer}: Dominic Comtois \email{dominic.comtois@gmail.com}

}
