% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finiteSum.R
\name{finiteSum}
\alias{finiteSum}
\title{Calculates the sum of a discrete series with a single maximum for a pre-set
number of evaluations}
\usage{
finiteSum(logFunction, parameters = numeric(), n, n0 = 0)
}
\arguments{
\item{logFunction}{The function that returns the series value
\ifelse{html}{\out{a<sub>n</sub>}}{\eqn{a_n}} in
the log scale. Can either be an \code{R} function or a string indicating one
of the precompiled functions. See \code{\link{precompiled}} for a list of
available functions. If defined in \code{R}, the function's definition must
have two arguments. The first argument must be the integer argument
equivalent to \eqn{n} in \ifelse{html}{\out{a<sub>n</sub>}}{\eqn{a_n}} and
the second must be a vector of numeric parameters.}

\item{parameters}{A numeric vector with parameters used in logFunction.
Vectorized summation over various parameter values sets is not implemented.
Use \code{\link{apply}} or their variants to achieve this.}

\item{n}{A single integer positive number indicating the number of iterations
to perform in the function.}

\item{n0}{The sum will be performed for the series starting at this value.}
}
\value{
A \code{\link{summed-objects}} object.
}
\description{
A discrete finite series is calculated exactly with no need for
approximations. This can also be used for infinite series approximation with
a pre-determined number of iterations, but this has no guarantee of quality
of approximation
}
\examples{
# Sum values from 5 to 100
finiteSum(function(x, p) log(x), numeric(), 100 - 5, 5)
}
\seealso{
\code{\link{precompiled}} provides a list with precompiled functions
that can be used for the summation.
}
