% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_hexagon.R
\name{fortify_hexagon}
\alias{fortify_hexagon}
\title{Creates the points that define a hexagon polygon for plotting}
\usage{
fortify_hexagon(data, sf_id, hex_size)
}
\arguments{
\item{data}{a data frame created by the allocate function}

\item{sf_id}{a string to indicate the column to identify individual polygons}

\item{hex_size}{a float value in degrees for the diameter of the hexagons}
}
\value{
a data frame of the seven points used to draw a hexagon
}
\description{
Creates the points that define a hexagon polygon for plotting
}
\examples{
# Create centroids set
centroids <- create_centroids(tas_lga, "LGA_CODE16")
# Create hexagon location grid
grid <- create_grid(centroids = centroids, hex_size = 0.2, buffer_dist = 1.2)
# Allocate polygon centroids to hexagon grid points
allocated <- allocate(
  centroids = centroids,
  sf_id = "LGA_CODE16",
  hex_grid = grid,
  hex_size = 0.2, # same size used in create_grid
  hex_filter = 1,
  width = 30,
  focal_points = capital_cities,
  verbose = TRUE
)
# same column used in create_centroids
fortify_hexagon(data = allocated, sf_id = "LGA_CODE16", hex_size = 0.2)
}
