% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subplot_sp.R
\name{subplot_sp}
\alias{subplot_sp}
\title{Plot a species subniche under each sub-environmental space K}
\usage{
subplot_sp(
  subnic,
  sp,
  main = NULL,
  col.axis = "azure3",
  lty.axis = 2,
  lwd.axis = 2,
  xlab = NULL,
  ylab = NULL,
  border.E = "black",
  col.E = "#92c5de",
  lty.E = 1,
  lwd.E = 1,
  border.K = "black",
  lwd.K = 1,
  col.K = "#2c7fb8",
  lty.K = 1,
  col.Gk.pos = "red",
  col.Gk.pt = "black",
  cex.Gk.pos = 1,
  pch.Gk.pos = 21,
  border.SP = "#bc5090",
  col.SB = "#ffff99",
  lty.SP = 1,
  lwd.SP = 2,
  border.NR = "#fdb462",
  col.NR = NA,
  lty.NR = 1,
  lwd.NR = 2,
  border.SR = "#a1d99b",
  col.SR = "#a1d99b",
  lty.SR = 1,
  lwd.SR = 1,
  pch.SR.pos = 19,
  cex.SR.pos = 1,
  col.SR.pt = "black",
  col.SR.pos = "black",
  cex.SR.lab = 0.7,
  col.SR.lab = "black",
  fac.SR.lab = 1.2,
  font.sp = 2,
  col.arrow = "black",
  angle.arrow = 20,
  lwd.arrow = 2,
  length.arrow = 0.1,
  leg = T,
  posi.leg = "topleft",
  bty.leg = "n",
  ...
)
}
\arguments{
\item{subnic}{an object of class \code{subniche}.}

\item{sp}{a character string of the species name.}

\item{main}{a main title for the plot, see \link[graphics]{title} for more details.}

\item{col.axis}{axis color, see \link[graphics]{par} for more details.}

\item{lty.axis}{axis line type, see \link[graphics]{par} for more details.}

\item{lwd.axis}{axis width, see \link[graphics]{par} for more details.}

\item{xlab}{label for x-axis, see \link[graphics]{title} for more details.}

\item{ylab}{label for y-axis, see \link[graphics]{title} for more details.}

\item{border.E}{color border of E polygon, see \link[graphics]{polygon} for more details.}

\item{col.E}{inside color of E polygon, see \link[graphics]{polygon} for more details.}

\item{lty.E}{line type for the E border, see \link[graphics]{polygon} for more details.}

\item{lwd.E}{line width for the E border, see \link[graphics]{polygon} for more details.}

\item{border.K}{color border of K polygon, see \link[graphics]{polygon} for more details.}

\item{lwd.K}{line width for the K border, see \link[graphics]{polygon} for more details.}

\item{col.K}{inside color of K polygon, see \link[graphics]{polygon} for more details.}

\item{lty.K}{line type for the K border, see \link[graphics]{polygon} for more details.}

\item{col.Gk.pos}{color of the point representing G_k, see \link[graphics]{points} for more details.}

\item{col.Gk.pt}{point color contour if pch=21:25.}

\item{cex.Gk.pos}{size of the point representing G_k, see \link[graphics]{points} for more details.}

\item{pch.Gk.pos}{type of the point representing G_k, see \link[graphics]{points} for more details.}

\item{border.SP}{color border of species subniche polygon, see \link[graphics]{polygon} for more details.}

\item{col.SB}{color of the SB area.}

\item{lty.SP}{line type for the SP border, see \link[graphics]{polygon} for more details.}

\item{lwd.SP}{line width for the SP border, see \link[graphics]{polygon} for more details.}

\item{border.NR}{color border of NR polygon, see \link[graphics]{polygon} for more details.}

\item{col.NR}{inside color of NR polygon, see \link[graphics]{polygon} for more details.}

\item{lty.NR}{line type for the NR border, see \link[graphics]{polygon} for more details.}

\item{lwd.NR}{line width for the NR border, see \link[graphics]{polygon} for more details.}

\item{border.SR}{color border of SR polygon, see \link[graphics]{polygon} for more details.}

\item{col.SR}{inside color of SR polygon, see \link[graphics]{polygon} for more details.}

\item{lty.SR}{line type for the SR border, see \link[graphics]{polygon} for more details.}

\item{lwd.SR}{line width for the SR border, see \link[graphics]{polygon} for more details.}

\item{pch.SR.pos}{type of points representing the SR position, see \link[graphics]{points} for more details.}

\item{cex.SR.pos}{size of points representing the SR position, see \link[graphics]{points} for more details.}

\item{col.SR.pt}{point color contour if pch=21:25.}

\item{col.SR.pos}{color of points representing the SR position, see \link[graphics]{points} for more details.}

\item{cex.SR.lab}{size of the species label representing the SR position, see \link[graphics]{text} for more details.}

\item{col.SR.lab}{color of the species label representing the SR position, see \link[graphics]{text} for more details.}

\item{fac.SR.lab}{factor for moving the SR labels from its original coordinates for clarity, by defaults they are multiply 1.2}

\item{font.sp}{An integer which specifies which font to use for species label. 1 corresponds to plain text (the default), 2 to bold face, 3 to italic and 4 to bold italic, see \link[graphics]{par} for more details.}

\item{col.arrow}{arrow color, see \link[graphics]{arrows} for more details.}

\item{angle.arrow}{arrow angle head, see \link[graphics]{arrows} for more details.}

\item{lwd.arrow}{arrow width, see \link[graphics]{arrows} for more details.}

\item{length.arrow}{arrow head length, see \link[graphics]{arrows} for more details.}

\item{leg}{a logical option for legend to be plotted or not, default leg=T.}

\item{posi.leg}{legend location in the graph, see \link[graphics]{legend} for more details.}

\item{bty.leg}{the type of box to be drawn around the legends. The allowed values are "o" (the default) and "n". See \link[graphics]{legend} for more details}

\item{...}{further arguments passed to or from other methods.}
}
\description{
The function to represent the species subniche under each subenvironment K with their respective marginality from G_K.
}
\examples{
library(subniche)
data(doubs)
dudi1 <- dudi.pca(doubs$env, scale = TRUE, scan = FALSE, nf = 3)
nic1 <- niche(dudi1, doubs$fish, scann = FALSE)
# number of sites
N <- dim(nic1$ls)[1]
#Create a factor which defines the subsets
fact <- factor(c(rep(1,N/2),rep(2,N/2)))
# nic1 will be use as reference and fact will be use to define the subniches environment
subnic1 <- subniche(nic1, fact)
eig <- round(subnic1$eig/sum(subnic1$eig)*100,2)[1:2]
#Two graphs are drawn one after the other
subplot_sp(subnic1,"Neba")
}
