% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform-block.R
\name{cache_find_block}
\alias{cache_find_block}
\title{Find the groups of expressions that should be processed together}
\usage{
cache_find_block(pd)
}
\arguments{
\item{pd}{A top level nest.}
}
\description{
Every expression is an expression itself, Expressions on same line are in
same block.
Multiple expressions can sit on one row, e.g. in line comment and commands
separated with ";". This creates a problem when processing each expression
separately because when putting them together, we need complicated handling
of line breaks between them, as it is not apriori clear that there is a line
break separating them. To avoid this, we put top level expressions that sit
on the same line into one block, so the assumption that there is a line break
between each block of expressions holds.
}
\details{
we want to for turning points:
\itemize{
\item change in cache state is a turning point
\item expressions that are not on a new line cannot be a turning point. In this
case, the turning point is moved to the first expression on the line
}
}
\keyword{internal}
