% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest.R
\name{drop_cached_children}
\alias{drop_cached_children}
\title{Drop all children of a top level expression that are cached}
\usage{
drop_cached_children(pd)
}
\arguments{
\item{pd}{A top-level nest.}
}
\description{
Note that we do not cache top-level comments. Because package code has a lot
of roxygen comments and each of them is a top level expression, checking is
very expensive. More expensive than styling, because comments are always
terminals.
}
\details{
Because we process in blocks of expressions for speed, a cached expression
will always end up in a block that won't be styled again (usual case), unless
it's on a line where multiple expressions sit and at least one is not styled
(exception).

\strong{usual case: All other expressions in a block are cached}

Cached expressions don't need to be transformed with \code{transformers} in
\code{\link[=parse_transform_serialize_r_block]{parse_transform_serialize_r_block()}}, we simply return \code{text} for the top
level token. For that
reason, the nested parse table can, at the rows where these expressions are
located, be shallow, i.e. it does not have to contain a child, because it
will neither be transformed nor serialized anytime. This function drops all
associated tokens except the top-level token for such expressions, which will
result in large speed improvements in \code{\link[=compute_parse_data_nested]{compute_parse_data_nested()}} because
nesting is expensive and will not be done for cached expressions.

\strong{exception: Not all other expressions in a block are cached}

As described in \code{\link[=cache_find_block]{cache_find_block()}}, expressions on the same line are always
put into one block. If any element of a block is not cached, the block will
be styled as a whole. If the parse table was made shallow (and the top level)
expression is still marked as non-terminal, \code{text} will never be used in the
transformation process and eventually lost. Hence, we must change the top
level expression to a terminal. It will act like a comment in the sense that
it is a fixed \code{text}.

Because for the usual case, it does not even matter if the cached expression
is a terminal or not (because it is not processed), we can safely set
\code{terminal = TRUE} in general.
}
\section{Implementation}{

Because the structure of the parse table is not always "top-level expression
first, then children", this function creates a temporary parse table that has
this property and then extract the ids and subset the original parse table so
it is shallow in the right places.
}

\keyword{internal}
