% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing-mocks.R
\name{style_text_without_curly_curly}
\alias{style_text_without_curly_curly}
\title{\code{style_text()} without rules for \code{\{\{}}
\usage{
style_text_without_curly_curly(text, ..., style = tidyverse_style,
  transformers = style(...), include_roxygen_examples = TRUE)
}
\description{
This function mocks \code{\link[=style_text]{style_text()}}, but without taking into consideration the
rules for the curly-curly syntactic sugar (introduced in rlang 0.4).
This function (\code{style_text_without_curly_curly()}) is needed for testing
only, namely to test indention
with multiple curly braces in a sequence. It is important to maintain testing
for indention rules even as the curly-curly expression is always kept on the
same line in the tidyverse style guide because we should
ensure the underlaying mechanics for indention work correctly. When
indention mechanisms are changed later, e.g. by simplifying
\code{\link[=compute_indent_indices]{compute_indent_indices()}}, we must have
a way of testing this without the interaction of \code{\{\{}.
}
\examples{
styler:::style_text_without_curly_curly("rlang::list2({{ x }} := 2)")
styler:::style_text("rlang::list2({{ x }} := 3)")
}
\seealso{
set_line_break_around_curly_curly
}
\keyword{internal}
