% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossvalidate.R
\name{crossvalidate}
\alias{crossvalidate}
\title{Cross-Validate a Measurement Model}
\usage{
crossvalidate(
  selection,
  old.data,
  new.data,
  max.invariance = "strict",
  filename = NULL
)
}
\arguments{
\item{selection}{An object of class \code{stuartOutput}.}

\item{old.data}{A \code{data.frame} of the calibration sample.}

\item{new.data}{A \code{data.frame} of the validation sample.}

\item{max.invariance}{The maximum measurement invariance level which will be tested. Currently there are four options: 'configural', 'weak', 'strong', and 'strict' (the default). All levels below \code{max.invariance} are also tested.}

\item{filename}{The stem of the filenames used to save inputs, outputs, and data files when \code{software='Mplus'}. This may include the file path. When \code{NULL} (the default) files will be saved to the temporary directory, which is deleted when the R session is ended.}
}
\value{
Returns a list containing the \code{data.frame} \code{comparison} and an object containing the model results of the four different invariance assumptions. 

\item{comparison}{A \code{data.frame} with 4 observations, each observation representing a level of measurement invariance. The number of columns depends on the arguments of the \code{objective} used in the original selection. In addition to those columns, three additional columns with the (corrected) Likelihood-Ratio-Tests are reported.}
\item{models}{A list of the four model results either of class \code{lavaan} or \code{mplus.model}, depending on the \code{software}-setting of the original selection.}
}
\description{
Cross-validate a measurement model obtained from STUART.
}
\examples{

# Split data into two halves
data(fairplayer)
half1 <- fairplayer[1:72,]
half2 <- fairplayer[73:143,]

# Simple example from bruteforce
fs <- list(ra = names(fairplayer)[53:57])
sel <- bruteforce(half1, fs, 3,
  cores = 1)  # number of cores set to 1

# Validation
crossvalidate(sel, half1, half2)

# Using the 'holdout' function for data split
data(fairplayer)
split <- holdout(fairplayer, seed = 55635)

# Simple example from bruteforce
fs <- list(ra = names(fairplayer)[53:57])
sel <- bruteforce(split, fs, 3,
  cores = 1)  # number of cores set to 1

# Validation
crossvalidate(sel, split)

}
\seealso{
\code{\link{holdout}}, \code{\link{mmas}}, \code{\link{bruteforce}}
}
\author{
Martin Schultze
}
\concept{ACO subtests}
