/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.multilabel.meta;

import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import com.yahoo.labs.samoa.instances.MultiLabelPrediction;
import com.yahoo.labs.samoa.instances.Prediction;
import moa.classifiers.Classifier;
import moa.classifiers.MultiLabelLearner;
import moa.classifiers.MultiTargetRegressor;
import moa.classifiers.meta.OzaBag;
import moa.core.Example;
import moa.core.InstanceExample;

public class OzaBagML
extends OzaBag
implements MultiLabelLearner,
MultiTargetRegressor {
    @Override
    public void trainOnInstanceImpl(MultiLabelInstance inst) {
        this.trainOnInstanceImpl((Instance)inst);
    }

    @Override
    public Prediction getPredictionForInstance(Example<Instance> example) {
        return OzaBagML.compilePredictions(this.ensemble, example);
    }

    public static Prediction compilePredictions(Classifier[] h, Example example) {
        Prediction[] predictions = new Prediction[h.length];
        for (int i = 0; i < h.length; ++i) {
            predictions[i] = h[i].getPredictionForInstance(example);
        }
        return OzaBagML.combinePredictions(predictions, (Instance)example.getData());
    }

    public static Prediction combinePredictions(Prediction[] predictions, Instance inst) {
        MultiLabelPrediction result = new MultiLabelPrediction(inst.numOutputAttributes());
        for (int i = 0; i < predictions.length; ++i) {
            try {
                Prediction more_votes = predictions[i];
                if (more_votes == null) continue;
                for (int numOutputAttribute = 0; numOutputAttribute < inst.numOutputAttributes(); ++numOutputAttribute) {
                    int length = 0;
                    if (more_votes.getVotes(numOutputAttribute) != null) {
                        length = more_votes.getVotes(numOutputAttribute).length;
                    }
                    for (int numValueAttribute = 0; numValueAttribute < length; ++numValueAttribute) {
                        result.setVote(numOutputAttribute, numValueAttribute, result.getVote(numOutputAttribute, numValueAttribute) + more_votes.getVote(numOutputAttribute, numValueAttribute) / (double)predictions.length);
                    }
                }
                continue;
            }
            catch (NullPointerException e) {
                System.err.println("NullPointer");
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.println("OutofBounds");
            }
        }
        return result;
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        return OzaBagML.compileVotes(this.ensemble, inst);
    }

    public static double[] compileVotes(Classifier[] h, Instance inst) {
        double[] votes = h[0].getVotesForInstance(inst);
        for (int i = 1; i < h.length; ++i) {
            try {
                double[] more_votes = h[i].getVotesForInstance(inst);
                for (int j = 0; j < more_votes.length; ++j) {
                    votes[j] = votes[j] + more_votes[j];
                }
                continue;
            }
            catch (NullPointerException e) {
                System.err.println("NullPointer");
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.println("OutofBounds");
            }
        }
        try {
            for (int j = 0; j < votes.length; ++j) {
                votes[j] = votes[j] / (double)h.length;
            }
        }
        catch (NullPointerException e) {
            System.err.println("NullPointer");
        }
        return votes;
    }

    @Override
    public Prediction getPredictionForInstance(MultiLabelInstance instance) {
        return this.getPredictionForInstance(new InstanceExample(instance));
    }
}

