/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.generators;

import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import moa.core.InstanceExample;
import moa.core.ObjectRepository;
import moa.streams.generators.WaveformGenerator;
import moa.tasks.TaskMonitor;

public class WaveformGeneratorDrift
extends WaveformGenerator {
    private static final long serialVersionUID = 1L;
    public IntOption numberAttributesDriftOption = new IntOption("numberAttributesDrift", 'd', "Number of attributes with drift.", 0, 0, 40);
    protected int[] numberAttribute;

    @Override
    public String getPurposeString() {
        return "Generates a problem of predicting one of three waveform types with drift.";
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        super.prepareForUseImpl(monitor, repository);
        int numAtts = this.addNoiseOption.isSet() ? 40 : 21;
        this.numberAttribute = new int[numAtts];
        for (int i = 0; i < numAtts; ++i) {
            this.numberAttribute[i] = i;
        }
        int randomInt = this.instanceRandom.nextInt(numAtts);
        int offset = this.instanceRandom.nextInt(numAtts);
        for (int i = 0; i < this.numberAttributesDriftOption.getValue(); ++i) {
            int swap = this.numberAttribute[(i + randomInt) % numAtts];
            this.numberAttribute[(i + randomInt) % numAtts] = this.numberAttribute[(i + offset) % numAtts];
            this.numberAttribute[(i + offset) % numAtts] = swap;
        }
    }

    @Override
    public InstanceExample nextInstance() {
        int i;
        InstancesHeader header = this.getHeader();
        DenseInstance inst = new DenseInstance((double)header.numAttributes());
        inst.setDataset(header);
        int waveform = this.instanceRandom.nextInt(3);
        int choiceA = 0;
        int choiceB = 0;
        switch (waveform) {
            case 0: {
                choiceA = 0;
                choiceB = 1;
                break;
            }
            case 1: {
                choiceA = 0;
                choiceB = 2;
                break;
            }
            case 2: {
                choiceA = 1;
                choiceB = 2;
            }
        }
        double multiplierA = this.instanceRandom.nextDouble();
        double multiplierB = 1.0 - multiplierA;
        for (i = 0; i < 21; ++i) {
            inst.setValue(this.numberAttribute[i], multiplierA * (double)hFunctions[choiceA][i] + multiplierB * (double)hFunctions[choiceB][i] + this.instanceRandom.nextGaussian());
        }
        if (this.addNoiseOption.isSet()) {
            for (i = 21; i < 40; ++i) {
                inst.setValue(this.numberAttribute[i], this.instanceRandom.nextGaussian());
            }
        }
        inst.setClassValue(waveform);
        return new InstanceExample(inst);
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

