/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.Prediction;
import moa.AbstractMOAObject;
import moa.core.Example;
import moa.core.Measurement;
import moa.evaluation.RegressionPerformanceEvaluator;

public class BasicRegressionPerformanceEvaluator
extends AbstractMOAObject
implements RegressionPerformanceEvaluator {
    private static final long serialVersionUID = 1L;
    protected double weightObserved;
    protected double squareError;
    protected double averageError;
    protected double sumTarget;
    protected double squareTargetError;
    protected double averageTargetError;

    @Override
    public void reset() {
        this.weightObserved = 0.0;
        this.squareError = 0.0;
        this.averageError = 0.0;
        this.sumTarget = 0.0;
        this.averageTargetError = 0.0;
        this.squareTargetError = 0.0;
    }

    @Override
    public void addResult(Example<Instance> example, double[] prediction) {
        Instance inst = example.getData();
        if (inst.weight() > 0.0 && prediction.length > 0) {
            double meanTarget = this.weightObserved != 0.0 ? this.sumTarget / this.weightObserved : 0.0;
            this.squareError += (inst.classValue() - prediction[0]) * (inst.classValue() - prediction[0]);
            this.averageError += Math.abs(inst.classValue() - prediction[0]);
            this.squareTargetError += (inst.classValue() - meanTarget) * (inst.classValue() - meanTarget);
            this.averageTargetError += Math.abs(inst.classValue() - meanTarget);
            this.sumTarget += inst.classValue();
            this.weightObserved += inst.weight();
        }
    }

    @Override
    public Measurement[] getPerformanceMeasurements() {
        return new Measurement[]{new Measurement("classified instances", this.getTotalWeightObserved()), new Measurement("mean absolute error", this.getMeanError()), new Measurement("root mean squared error", this.getSquareError()), new Measurement("relative mean absolute error", this.getRelativeMeanError()), new Measurement("relative root mean squared error", this.getRelativeSquareError())};
    }

    public double getTotalWeightObserved() {
        return this.weightObserved;
    }

    public double getMeanError() {
        return this.weightObserved > 0.0 ? this.averageError / this.weightObserved : 0.0;
    }

    public double getSquareError() {
        return Math.sqrt(this.weightObserved > 0.0 ? this.squareError / this.weightObserved : 0.0);
    }

    public double getTargetMeanError() {
        return this.weightObserved > 0.0 ? this.averageTargetError / this.weightObserved : 0.0;
    }

    public double getTargetSquareError() {
        return Math.sqrt(this.weightObserved > 0.0 ? this.squareTargetError / this.weightObserved : 0.0);
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        Measurement.getMeasurementsDescription(this.getPerformanceMeasurements(), sb, indent);
    }

    private double getRelativeMeanError() {
        return this.averageTargetError > 0.0 ? this.averageError / this.averageTargetError : 0.0;
    }

    private double getRelativeSquareError() {
        return Math.sqrt(this.squareTargetError > 0.0 ? this.squareError / this.squareTargetError : 0.0);
    }

    @Override
    public void addResult(Example<Instance> example, Prediction prediction) {
        if (prediction != null) {
            this.addResult(example, prediction.getVotes(0));
        }
    }
}

