/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.trees;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Stack;
import moa.AbstractMOAObject;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.Regressor;
import moa.classifiers.core.AttributeSplitSuggestion;
import moa.classifiers.core.attributeclassobservers.FIMTDDNumericAttributeClassObserver;
import moa.classifiers.core.conditionaltests.InstanceConditionalTest;
import moa.classifiers.core.splitcriteria.SplitCriterion;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.core.SizeOf;
import moa.core.StringUtils;
import moa.options.ClassOption;
import moa.options.FlagOption;
import moa.options.FloatOption;
import moa.options.IntOption;
import weka.core.Instance;

public class FIMTDD
extends AbstractClassifier
implements Regressor {
    private static final long serialVersionUID = 1L;
    protected Node treeRoot;
    private int leafNodeCount = 0;
    private int splitNodeCount = 0;
    private double examplesSeen = 0.0;
    private double sumOfValues = 0.0;
    private double sumOfSquares = 0.0;
    private DoubleVector sumOfAttrValues = new DoubleVector();
    private DoubleVector sumOfAttrSquares = new DoubleVector();
    public int maxID = 0;
    public ClassOption splitCriterionOption = new ClassOption("splitCriterion", 's', "Split criterion to use.", SplitCriterion.class, "moa.classifiers.core.splitcriteria.VarianceReductionSplitCriterion");
    public IntOption gracePeriodOption = new IntOption("gracePeriod", 'g', "The number of instances a leaf should observe between split attempts.", 200, 0, Integer.MAX_VALUE);
    public FloatOption splitConfidenceOption = new FloatOption("splitConfidence", 'c', "The allowable error in split decision, values closer to 0 will take longer to decide.", 1.0E-7, 0.0, 1.0);
    public FloatOption tieThresholdOption = new FloatOption("tieThreshold", 't', "Threshold below which a split will be forced to break ties.", 0.05, 0.0, 1.0);
    public FloatOption PageHinckleyAlphaOption = new FloatOption("PageHinckleyAlpha", 'a', "The alpha value to use in the Page Hinckley change detection tests.", 0.005, 0.0, 1.0);
    public IntOption PageHinckleyThresholdOption = new IntOption("PageHinckleyThreshold", 'h', "The threshold value to be used in the Page Hinckley change detection tests.", 50, 0, Integer.MAX_VALUE);
    public FloatOption alternateTreeFadingFactorOption = new FloatOption("alternateTreeFadingFactor", 'f', "The fading factor to use when deciding if an alternate tree should replace an original.", 0.995, 0.0, 1.0);
    public IntOption alternateTreeTMinOption = new IntOption("alternateTreeTMin", 'y', "The Tmin value to use when deciding if an alternate tree should replace an original.", 150, 0, Integer.MAX_VALUE);
    public IntOption alternateTreeTimeOption = new IntOption("alternateTreeTime", 'u', "The 'time' (in terms of number of instances) value to use when deciding if an alternate tree should be discarded.", 1500, 0, Integer.MAX_VALUE);
    public FlagOption regressionTreeOption = new FlagOption("regressionTree", 'e', "Build a regression tree instead of a model tree.");
    public FloatOption learningRatioOption = new FloatOption("learningRatio", 'l', "Learning ratio to use for training the Perceptrons in the leaves.", 0.02);
    public FloatOption learningRateDecayFactorOption = new FloatOption("learningRatioDecayFactor", 'd', "Learning rate decay factor (not used when learning rate is constant).", 0.001);
    public FlagOption learningRatioConstOption = new FlagOption("learningRatioConst", 'o', "Keep learning rate constant instead of decaying (if kept constant learning ratio is suggested to be 0.001).");

    public String getPurposeString() {
        return "Implementation of the FIMT-DD tree as described by Ikonomovska et al.";
    }

    public void resetLearningImpl() {
        this.treeRoot = null;
        this.leafNodeCount = 0;
        this.splitNodeCount = 0;
        this.maxID = 0;
    }

    public boolean isRandomizable() {
        return true;
    }

    public void getModelDescription(StringBuilder out, int indent) {
        if (this.treeRoot != null) {
            this.treeRoot.describeSubtree(this, out, indent);
        }
    }

    protected Measurement[] getModelMeasurementsImpl() {
        return new Measurement[]{new Measurement("tree size (nodes)", this.leafNodeCount + this.splitNodeCount), new Measurement("tree size (leaves)", this.leafNodeCount)};
    }

    public int calcByteSize() {
        int size = (int)SizeOf.sizeOf(this);
        if (this.treeRoot != null) {
            size += this.treeRoot.calcByteSize();
        }
        return size;
    }

    public double[] getVotesForInstance(Instance inst) {
        if (this.treeRoot == null) {
            return new double[]{0.0};
        }
        double prediction = this.treeRoot.getPrediction(inst, this);
        return new double[]{prediction};
    }

    public double normalizeTargetValue(double value) {
        if (this.examplesSeen > 1.0) {
            double sd = Math.sqrt((this.sumOfSquares - this.sumOfValues * this.sumOfValues / this.examplesSeen) / this.examplesSeen);
            double average = this.sumOfValues / this.examplesSeen;
            if (sd > 0.0 && this.examplesSeen > 1.0) {
                return (value - average) / (3.0 * sd);
            }
            return 0.0;
        }
        return 0.0;
    }

    public double getNormalizedError(Instance inst) {
        double normalPrediction = this.normalizeTargetValue(this.treeRoot.getPrediction(inst, this));
        double normalValue = this.normalizeTargetValue(inst.classValue());
        return Math.abs(normalValue - normalPrediction);
    }

    public void trainOnInstanceImpl(Instance inst) {
        this.checkRoot();
        this.examplesSeen += 1.0;
        this.sumOfValues += inst.classValue();
        this.sumOfSquares += inst.classValue() * inst.classValue();
        for (int i = 0; i < inst.numAttributes() - 1; ++i) {
            int aIndex = FIMTDD.modelAttIndexToInstanceAttIndex(i, inst);
            this.sumOfAttrValues.addToValue(aIndex, inst.value(aIndex));
            this.sumOfAttrSquares.addToValue(aIndex, inst.value(aIndex) * inst.value(aIndex));
        }
        this.processInstance(inst, this.treeRoot, this.treeRoot.getPrediction(inst, this), this.getNormalizedError(inst), true, false);
    }

    public void processInstance(Instance inst, Node node, double prediction, double normalError, boolean growthAllowed, boolean inAlternate) {
        block13: {
            Node currentNode = node;
            while (true) {
                if (currentNode instanceof LeafNode) {
                    ((LeafNode)currentNode).learnFromInstance(inst, this, growthAllowed);
                    break block13;
                }
                currentNode.examplesSeen += 1.0;
                currentNode.sumOfAbsErrors += normalError;
                SplitNode iNode = (SplitNode)currentNode;
                if (!inAlternate && iNode.alternateTree != null) {
                    boolean altTree = true;
                    double lossO = Math.pow(inst.classValue() - prediction, 2.0);
                    double lossA = Math.pow(inst.classValue() - iNode.alternateTree.getPrediction(inst, this), 2.0);
                    iNode.lossFadedSumOriginal = lossO + this.alternateTreeFadingFactorOption.getValue() * iNode.lossFadedSumOriginal;
                    iNode.lossFadedSumAlternate = lossA + this.alternateTreeFadingFactorOption.getValue() * iNode.lossFadedSumAlternate;
                    iNode.lossExamplesSeen += 1.0;
                    double Qi = Math.log(iNode.lossFadedSumOriginal / iNode.lossFadedSumAlternate);
                    double previousQiAverage = iNode.lossSumQi / iNode.lossNumQiTests;
                    iNode.lossSumQi += Qi;
                    iNode.lossNumQiTests += 1.0;
                    double QiAverage = iNode.lossSumQi / iNode.lossNumQiTests;
                    if (iNode.lossExamplesSeen - iNode.previousWeight >= (double)this.alternateTreeTMinOption.getValue()) {
                        iNode.previousWeight = iNode.lossExamplesSeen;
                        if (Qi > 0.0) {
                            SplitNode parent = currentNode.getParent();
                            if (parent != null) {
                                Node replacementTree = iNode.alternateTree;
                                parent.setChild(parent.getChildIndex(currentNode), replacementTree);
                                if (growthAllowed) {
                                    replacementTree.restartChangeDetection();
                                }
                            } else {
                                this.treeRoot = iNode.alternateTree;
                                this.treeRoot.restartChangeDetection();
                            }
                            currentNode = iNode.alternateTree;
                            altTree = false;
                        } else if (QiAverage < previousQiAverage && iNode.lossExamplesSeen >= (double)(10 * this.gracePeriodOption.getValue()) || iNode.lossExamplesSeen >= (double)this.alternateTreeTimeOption.getValue()) {
                            iNode.alternateTree = null;
                            if (growthAllowed) {
                                iNode.restartChangeDetection();
                            }
                            altTree = false;
                        }
                    }
                    if (altTree) {
                        growthAllowed = false;
                        this.processInstance(inst, iNode.alternateTree, prediction, normalError, true, true);
                    }
                }
                if (iNode.changeDetection && !inAlternate && iNode.PageHinckleyTest(normalError - iNode.sumOfAbsErrors / iNode.examplesSeen - this.PageHinckleyAlphaOption.getValue(), this.PageHinckleyThresholdOption.getValue())) {
                    iNode.initializeAlternateTree(this);
                }
                if (!(currentNode instanceof SplitNode)) break;
                currentNode = ((SplitNode)currentNode).getChild(iNode.instanceChildIndex(inst));
            }
            ((LeafNode)currentNode).learnFromInstance(inst, this, growthAllowed);
        }
    }

    protected FIMTDDNumericAttributeClassObserver newNumericClassObserver() {
        return new FIMTDDNumericAttributeClassObserver();
    }

    protected SplitNode newSplitNode(InstanceConditionalTest splitTest) {
        return new SplitNode(splitTest, this);
    }

    protected LeafNode newLeafNode() {
        ++this.maxID;
        return new LeafNode(this);
    }

    protected FIMTDDPerceptron newLeafModel() {
        return new FIMTDDPerceptron();
    }

    protected void checkRoot() {
        if (this.treeRoot == null) {
            this.treeRoot = this.newLeafNode();
            this.leafNodeCount = 1;
        }
    }

    public static double computeHoeffdingBound(double range, double confidence, double n) {
        return Math.sqrt(range * range * Math.log(1.0 / confidence) / (2.0 * n));
    }

    public boolean buildingModelTree() {
        return !this.regressionTreeOption.isSet();
    }

    protected void attemptToSplit(LeafNode node, SplitNode parent, int parentIndex) {
        SplitCriterion splitCriterion = (SplitCriterion)this.getPreparedClassOption(this.splitCriterionOption);
        Object[] bestSplitSuggestions = node.getBestSplitSuggestions(splitCriterion, this);
        Arrays.sort(bestSplitSuggestions);
        boolean shouldSplit = false;
        if (bestSplitSuggestions.length < 2) {
            shouldSplit = bestSplitSuggestions.length > 0;
        } else {
            double hoeffdingBound = FIMTDD.computeHoeffdingBound(1.0, this.splitConfidenceOption.getValue(), node.examplesSeen());
            Object bestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 1];
            Object secondBestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 2];
            if (((AttributeSplitSuggestion)secondBestSuggestion).merit / ((AttributeSplitSuggestion)bestSuggestion).merit < 1.0 - hoeffdingBound || hoeffdingBound < this.tieThresholdOption.getValue()) {
                shouldSplit = true;
            } else {
                for (int i = 0; i < node.attributeObservers.size(); ++i) {
                    FIMTDDNumericAttributeClassObserver obs = (FIMTDDNumericAttributeClassObserver)node.attributeObservers.get(i);
                    if (obs == null) continue;
                    obs.removeBadSplits(splitCriterion, ((AttributeSplitSuggestion)secondBestSuggestion).merit / ((AttributeSplitSuggestion)bestSuggestion).merit, ((AttributeSplitSuggestion)bestSuggestion).merit, hoeffdingBound);
                }
            }
        }
        if (shouldSplit) {
            Object splitDecision = bestSplitSuggestions[bestSplitSuggestions.length - 1];
            SplitNode newSplit = this.newSplitNode(((AttributeSplitSuggestion)splitDecision).splitTest);
            newSplit.copyStatistics(node);
            newSplit.changeDetection = node.changeDetection;
            newSplit.ID = node.ID;
            --this.leafNodeCount;
            for (int i = 0; i < ((AttributeSplitSuggestion)splitDecision).numSplits(); ++i) {
                LeafNode newChild = this.newLeafNode();
                if (this.buildingModelTree()) {
                    newChild.learningModel = new FIMTDDPerceptron(node.learningModel);
                }
                newChild.changeDetection = node.changeDetection;
                newChild.setParent(newSplit);
                newSplit.setChild(i, newChild);
                ++this.leafNodeCount;
            }
            if (parent == null && node.originalNode == null) {
                this.treeRoot = newSplit;
            } else if (parent == null && node.originalNode != null) {
                node.originalNode.alternateTree = newSplit;
            } else {
                parent.setChild(parentIndex, newSplit);
                newSplit.setParent(parent);
            }
            ++this.splitNodeCount;
        }
    }

    public double computeSD(double squaredVal, double val, double size) {
        if (size > 1.0) {
            return Math.sqrt((squaredVal - val * val / size) / size);
        }
        return 0.0;
    }

    public double scalarProduct(DoubleVector u, DoubleVector v) {
        double ret = 0.0;
        for (int i = 0; i < Math.max(u.numValues(), v.numValues()); ++i) {
            ret += u.getValue(i) * v.getValue(i);
        }
        return ret;
    }

    public class FIMTDDPerceptron {
        protected DoubleVector weightAttribute = new DoubleVector();
        protected double sumOfValues;
        protected double sumOfSquares;
        protected int instancesSeen = 0;
        protected boolean reset;

        public String getPurposeString() {
            return "A perceptron regressor as specified by Ikonomovska et al. used for FIMTDD";
        }

        public FIMTDDPerceptron(FIMTDDPerceptron original) {
            this.weightAttribute = (DoubleVector)original.weightAttribute.copy();
            this.reset = false;
        }

        public FIMTDDPerceptron() {
            this.reset = true;
        }

        public DoubleVector getWeights() {
            return this.weightAttribute;
        }

        public void updatePerceptron(Instance inst, FIMTDD tree) {
            if (this.reset) {
                this.reset = false;
                this.weightAttribute = new DoubleVector();
                this.instancesSeen = 0;
                for (int j = 0; j < inst.numAttributes(); ++j) {
                    this.weightAttribute.setValue(j, 2.0 * tree.classifierRandom.nextDouble() - 1.0);
                }
            }
            ++this.instancesSeen;
            double learningRatio = 0.0;
            learningRatio = tree.learningRatioConstOption.isSet() ? FIMTDD.this.learningRatioOption.getValue() : FIMTDD.this.learningRatioOption.getValue() / (1.0 + (double)this.instancesSeen * tree.learningRateDecayFactorOption.getValue());
            this.sumOfValues += inst.classValue();
            this.sumOfSquares += inst.classValue() * inst.classValue();
            this.updateWeights(inst, learningRatio, tree);
        }

        public void updateWeights(Instance inst, double learningRatio, FIMTDD tree) {
            DoubleVector normalizedInstance = this.normalizedInstance(inst, tree);
            double normalizedPrediction = this.prediction(normalizedInstance);
            double normalizedValue = tree.normalizeTargetValue(inst.classValue());
            double delta = normalizedValue - normalizedPrediction;
            normalizedInstance.scaleValues(delta * learningRatio);
            this.weightAttribute.addValues(normalizedInstance);
        }

        public DoubleVector normalizedInstance(Instance inst, FIMTDD tree) {
            DoubleVector normalizedInstance = new DoubleVector();
            for (int j = 0; j < inst.numAttributes() - 1; ++j) {
                int instAttIndex = FIMTDD.modelAttIndexToInstanceAttIndex(j, inst);
                double mean = tree.sumOfAttrValues.getValue(j) / tree.examplesSeen;
                double sd = FIMTDD.this.computeSD(tree.sumOfAttrSquares.getValue(j), tree.sumOfAttrValues.getValue(j), tree.examplesSeen);
                if (inst.attribute(instAttIndex).isNumeric() && tree.examplesSeen > 1.0 && sd > 0.0) {
                    normalizedInstance.setValue(j, (inst.value(instAttIndex) - mean) / (3.0 * sd));
                    continue;
                }
                normalizedInstance.setValue(j, 0.0);
            }
            if (tree.examplesSeen > 1.0) {
                normalizedInstance.setValue(inst.numAttributes() - 1, 1.0);
            } else {
                normalizedInstance.setValue(inst.numAttributes() - 1, 0.0);
            }
            return normalizedInstance;
        }

        public double prediction(DoubleVector instanceValues) {
            return FIMTDD.this.scalarProduct(this.weightAttribute, instanceValues);
        }

        private double prediction(Instance inst, FIMTDD tree) {
            DoubleVector normalizedInstance = this.normalizedInstance(inst, tree);
            double normalizedPrediction = this.prediction(normalizedInstance);
            return this.denormalizePrediction(normalizedPrediction, tree);
        }

        private double denormalizePrediction(double normalizedPrediction, FIMTDD tree) {
            double mean = tree.sumOfValues / tree.examplesSeen;
            double sd = FIMTDD.this.computeSD(tree.sumOfSquares, tree.sumOfValues, tree.examplesSeen);
            if (FIMTDD.this.examplesSeen > 1.0) {
                return normalizedPrediction * sd * 3.0 + mean;
            }
            return 0.0;
        }

        public void getModelDescription(StringBuilder out, int indent) {
            StringUtils.appendIndented(out, indent, FIMTDD.this.getClassNameString() + " =");
            if (FIMTDD.this.getModelContext() != null) {
                for (int j = 0; j < FIMTDD.this.getModelContext().numAttributes() - 1; ++j) {
                    if (!FIMTDD.this.getModelContext().attribute(j).isNumeric()) continue;
                    out.append(j == 0 || this.weightAttribute.getValue(j) < 0.0 ? " " : " + ");
                    out.append(String.format("%.4f", this.weightAttribute.getValue(j)));
                    out.append(" * ");
                    out.append(FIMTDD.this.getAttributeNameString(j));
                }
                out.append(" + " + this.weightAttribute.getValue(FIMTDD.this.getModelContext().numAttributes() - 1));
            }
            StringUtils.appendNewline(out);
        }
    }

    public static class SplitNode
    extends Node {
        private static final long serialVersionUID = 1L;
        protected InstanceConditionalTest splitTest;
        protected AutoExpandVector<Node> children = new AutoExpandVector();
        protected double lossExamplesSeen;
        protected double lossFadedSumOriginal;
        protected double lossFadedSumAlternate;
        protected double lossNumQiTests;
        protected double lossSumQi;
        protected double previousWeight = 0.0;

        public SplitNode(InstanceConditionalTest splitTest, FIMTDD tree) {
            this.splitTest = splitTest;
            this.ID = tree.maxID;
        }

        public void disableChangeDetection() {
            this.changeDetection = false;
            for (Node child : this.children) {
                child.disableChangeDetection();
            }
        }

        public void restartChangeDetection() {
            if (this.alternateTree == null) {
                this.changeDetection = true;
                this.PHsum = 0.0;
                this.PHmin = 2.147483647E9;
                for (Node child : this.children) {
                    child.restartChangeDetection();
                }
            }
        }

        protected void setChild(int i, Node child) {
            this.children.set(i, child);
        }

        public int instanceChildIndex(Instance inst) {
            return this.splitTest.branchForInstance(inst);
        }

        public Node getChild(int i) {
            return this.children.get(i);
        }

        public int getChildIndex(Node child) {
            return this.children.indexOf(child);
        }

        public void initializeAlternateTree(FIMTDD tree) {
            this.alternateTree = tree.newLeafNode();
            this.alternateTree.originalNode = this;
            this.lossExamplesSeen = 0.0;
            this.lossFadedSumOriginal = 0.0;
            this.lossFadedSumAlternate = 0.0;
            this.lossNumQiTests = 0.0;
            this.lossSumQi = 0.0;
            this.previousWeight = 0.0;
            this.disableChangeDetection();
        }

        public int countLeaves() {
            Stack<Node> stack = new Stack<Node>();
            stack.addAll(this.children);
            int ret = 0;
            while (!stack.isEmpty()) {
                Node node = (Node)stack.pop();
                if (node instanceof LeafNode) {
                    ++ret;
                    continue;
                }
                if (!(node instanceof SplitNode)) continue;
                stack.addAll(((SplitNode)node).children);
            }
            return ret;
        }

        public void describeSubtree(FIMTDD tree, StringBuilder out, int indent) {
            for (int branch = 0; branch < this.children.size(); ++branch) {
                Node child = this.getChild(branch);
                if (child == null) continue;
                StringUtils.appendIndented(out, indent, "if ");
                out.append(this.splitTest.describeConditionForBranch(branch, tree.getModelContext()));
                out.append(": ");
                StringUtils.appendNewline(out);
                child.describeSubtree(tree, out, indent + 2);
            }
        }

        public double getPrediction(Instance inst, FIMTDD tree) {
            return this.children.get(this.splitTest.branchForInstance(inst)).getPrediction(inst, tree);
        }
    }

    public static class LeafNode
    extends Node {
        private static final long serialVersionUID = 1L;
        public FIMTDDPerceptron learningModel;
        protected double examplesSeenAtLastSplitEvaluation = 0.0;

        public double examplesSeenAtLastSplitEvaluation() {
            return this.examplesSeenAtLastSplitEvaluation;
        }

        public void setExamplesSeenAtLastSplitEvaluation(double seen) {
            this.examplesSeenAtLastSplitEvaluation = seen;
        }

        public LeafNode(FIMTDD tree) {
            this.ID = tree.maxID;
            if (tree.buildingModelTree()) {
                this.learningModel = tree.newLeafModel();
            }
            this.examplesSeen = 0.0;
            this.sumOfValues = 0.0;
            this.sumOfSquares = 0.0;
            this.sumOfAbsErrors = 0.0;
        }

        public void learnFromInstance(Instance inst, FIMTDD tree, boolean growthAllowed) {
            this.examplesSeen += 1.0;
            this.sumOfValues += inst.classValue();
            this.sumOfSquares += inst.classValue() * inst.classValue();
            this.sumOfAbsErrors += Math.abs(tree.normalizeTargetValue(inst.classValue()) - tree.normalizeTargetValue(this.getPrediction(inst, tree)));
            if (tree.buildingModelTree()) {
                this.learningModel.updatePerceptron(inst, tree);
            }
            for (int i = 0; i < inst.numAttributes() - 1; ++i) {
                int instAttIndex = FIMTDD.modelAttIndexToInstanceAttIndex(i, inst);
                FIMTDDNumericAttributeClassObserver obs = (FIMTDDNumericAttributeClassObserver)this.attributeObservers.get(i);
                if (obs == null && inst.attribute(instAttIndex).isNumeric()) {
                    obs = tree.newNumericClassObserver();
                    this.attributeObservers.set(i, obs);
                }
                if (obs == null) continue;
                obs.observeAttributeClass(inst.value(instAttIndex), inst.classValue(), inst.weight());
            }
            if (growthAllowed) {
                this.checkForSplit(tree);
            }
        }

        public AttributeSplitSuggestion[] getBestSplitSuggestions(SplitCriterion criterion, FIMTDD tree) {
            LinkedList<AttributeSplitSuggestion> bestSuggestions = new LinkedList<AttributeSplitSuggestion>();
            double[] nodeSplitDist = new double[]{this.examplesSeen, this.sumOfValues, this.sumOfSquares};
            for (int i = 0; i < this.attributeObservers.size(); ++i) {
                FIMTDDNumericAttributeClassObserver obs = (FIMTDDNumericAttributeClassObserver)this.attributeObservers.get(i);
                if (obs == null) continue;
                AttributeSplitSuggestion bestSuggestion = null;
                if (obs instanceof FIMTDDNumericAttributeClassObserver) {
                    bestSuggestion = obs.getBestEvaluatedSplitSuggestion(criterion, nodeSplitDist, i, false);
                }
                if (bestSuggestion == null) continue;
                bestSuggestions.add(bestSuggestion);
            }
            return bestSuggestions.toArray(new AttributeSplitSuggestion[bestSuggestions.size()]);
        }

        public double getPredictionModel(Instance inst, FIMTDD tree) {
            return this.learningModel.prediction(inst, tree);
        }

        public double getPredictionTargetMean(Instance inst, FIMTDD tree) {
            return this.examplesSeen > 0.0 ? this.sumOfValues / this.examplesSeen : 0.0;
        }

        public double getPrediction(Instance inst, FIMTDD tree) {
            return tree.buildingModelTree() ? this.getPredictionModel(inst, tree) : this.getPredictionTargetMean(inst, tree);
        }

        public double[] getClassVotes(Instance inst, FIMTDD tree) {
            return new double[]{this.getPrediction(inst, tree)};
        }

        public void checkForSplit(FIMTDD tree) {
            if (this.examplesSeen - this.examplesSeenAtLastSplitEvaluation >= (double)tree.gracePeriodOption.getValue()) {
                int index = this.parent != null ? this.parent.getChildIndex(this) : 0;
                tree.attemptToSplit(this, this.parent, index);
                this.examplesSeenAtLastSplitEvaluation = this.examplesSeen;
            }
        }

        public void describeSubtree(FIMTDD tree, StringBuilder out, int indent) {
            StringUtils.appendIndented(out, indent, "Leaf ");
            if (tree.buildingModelTree()) {
                this.learningModel.getModelDescription(out, 0);
            } else {
                out.append(tree.getClassNameString() + " = " + String.format("%.4f", this.sumOfValues / this.examplesSeen));
                StringUtils.appendNewline(out);
            }
        }
    }

    public static abstract class Node
    extends AbstractMOAObject {
        private static final long serialVersionUID = 1L;
        protected double weightSeenAtLastSplitEvaluation;
        public int ID;
        protected SplitNode parent;
        protected Node alternateTree;
        protected Node originalNode;
        protected AutoExpandVector<FIMTDDNumericAttributeClassObserver> attributeObservers = new AutoExpandVector();
        protected boolean changeDetection = true;
        protected double PHsum = 0.0;
        protected double PHmin = Double.MAX_VALUE;
        protected double examplesSeen;
        protected double sumOfValues;
        protected double sumOfSquares;
        protected double sumOfAbsErrors;

        public void copyStatistics(Node node) {
            this.examplesSeen = node.examplesSeen;
            this.sumOfValues = node.sumOfValues;
            this.sumOfSquares = node.sumOfSquares;
            this.sumOfAbsErrors = node.sumOfAbsErrors;
        }

        public int calcByteSize() {
            return (int)SizeOf.sizeOf(this) + (int)SizeOf.fullSizeOf(this.attributeObservers);
        }

        public int calcByteSizeIncludingSubtree() {
            return this.calcByteSize();
        }

        public boolean isLeaf() {
            return true;
        }

        public double examplesSeen() {
            return this.examplesSeen;
        }

        public void setParent(SplitNode parent) {
            this.parent = parent;
        }

        public SplitNode getParent() {
            return this.parent;
        }

        public void disableChangeDetection() {
            this.changeDetection = false;
        }

        public void restartChangeDetection() {
            this.changeDetection = true;
            this.PHsum = 0.0;
            this.PHmin = 2.147483647E9;
        }

        public boolean PageHinckleyTest(double error, double threshold) {
            this.PHsum += error;
            if (this.PHsum < this.PHmin) {
                this.PHmin = this.PHsum;
            }
            return this.PHsum - this.PHmin > threshold;
        }

        public void getDescription(StringBuilder sb, int i) {
        }

        public int countLeaves() {
            return 1;
        }

        public void describeSubtree(FIMTDD tree, StringBuilder out, int indent) {
            StringUtils.appendIndented(out, indent, "Leaf");
        }

        public double getPrediction(Instance inst, FIMTDD tree) {
            return 0.0;
        }
    }
}

