% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update}
\alias{update}
\alias{update.DST}
\title{Update a Data Stream Mining Task Model with Points from a Stream}
\usage{
\method{update}{DST}(object, dsd, n = 1L, return = "nothing", ...)
}
\arguments{
\item{object}{The \link{DST} object.}

\item{dsd}{A \link{DSD} object with the data stream.}

\item{n}{number of points from \code{dsd} to use for the update. Some DSD \code{dsd} accept \code{n = -1} to update with all remaining points in the stream.}

\item{return}{a character string indicating what update returns. The default is \code{"nothing"}. Other
possible values depend on the \code{DST}. Examples are \code{"data"}, \code{"model"} and \code{"assignment"}.}

\item{...}{Additional arguments are passed on.}
}
\value{
\code{NULL} or a data.frame \code{n} rows containing update information for each data point.
}
\description{
\code{update()} for data stream mining tasks \link{DST}.
}
\examples{
set.seed(1500)
stream <- DSD_Gaussians(k = 3, d = 2, noise = .1)

dbstream <- DSC_DBSTREAM(r = .1)
assignment <- update(dbstream, stream, n = 100, return = "assignment")
plot(dbstream, stream, type = "both")

# DBSTREAM returns cluster assignments (see DSC_DBSTREAM).
head(assignment)
}
\seealso{
Other DST: 
\code{\link{DSAggregate}()},
\code{\link{DSC}()},
\code{\link{DSClassifier}()},
\code{\link{DSOutlier}()},
\code{\link{DSRegressor}()},
\code{\link{DST}()},
\code{\link{DST_SlidingWindow}()},
\code{\link{DST_WriteStream}()},
\code{\link{evaluate}},
\code{\link{predict}()},
\code{\link{stream_pipeline}}
}
\author{
Michael Hahsler
}
\concept{DST}
