% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSC_Hierarchical.R
\name{DSC_Hierarchical}
\alias{DSC_Hierarchical}
\title{Hierarchical Micro-Cluster Reclusterer}
\usage{
DSC_Hierarchical(
  formula = NULL,
  k = NULL,
  h = NULL,
  method = "complete",
  min_weight = NULL,
  description = NULL
)
}
\arguments{
\item{formula}{\code{NULL} to use all features in the stream or a model \link{formula} of the form \code{~ X1 + X2}
to specify the features used for clustering. Only \code{.}, \code{+} and \code{-} are currently
supported in the formula.}

\item{k}{The number of desired clusters.}

\item{h}{Height where to cut the dendrogram.}

\item{method}{the agglomeration method to be used. This should be (an
unambiguous abbreviation of) one of \code{"ward"}, \code{"single"}, \code{"complete"}, "\verb{average"},
\code{"mcquitty"}, \code{"median"} or \code{"centroid"}.}

\item{min_weight}{micro-clusters with a weight less than this will be
ignored for reclustering.}

\item{description}{optional character string to describe the clustering method.}
}
\value{
A list of class \link{DSC}, \link{DSC_R}, \link{DSC_Macro}, and
\code{DSC_Hierarchical}. The list contains the following items:

\item{description}{The name of the algorithm in the DSC object.}
\item{RObj}{The underlying R object.}
}
\description{
Macro Clusterer.
Implementation of hierarchical clustering to recluster a set of
micro-clusters.
}
\details{
Please refer to \code{\link[=hclust]{hclust()}} for more details on the behavior of the
algorithm.

\code{\link[=update]{update()}} and \code{\link[=recluster]{recluster()}} invisibly return the assignment of the data points
to clusters.

\strong{Note} that this clustering cannot be updated iteratively and every time it is
used for (re)clustering, the old clustering is deleted.
}
\examples{
stream <- DSD_Gaussians(k = 3, d = 2, noise = 0.05)

# Use a moving window for "micro-clusters and recluster with HC (macro-clusters)
cl <- DSC_TwoStage(
  micro = DSC_Window(horizon = 100),
  macro = DSC_Hierarchical(h = .1, method = "single")
)

update(cl, stream, 500)
cl

plot(cl, stream)
}
\seealso{
Other DSC_Macro: 
\code{\link{DSC_DBSCAN}()},
\code{\link{DSC_EA}()},
\code{\link{DSC_Kmeans}()},
\code{\link{DSC_Macro}()},
\code{\link{DSC_Reachability}()}
}
\author{
Michael Hahsler
}
\concept{DSC_Macro}
