% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nucleotideDivergence.R
\name{nucleotideDivergence}
\alias{nucleotideDivergence}
\alias{dA}
\title{Nucleotide Divergence}
\usage{
nucleotideDivergence(g, probs = c(0, 0.025, 0.5, 0.975, 1), model = "raw", ...)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{probs}{a numeric vector of probabilities of the pairwise distance 
distributions with values in \code{0:1}.}

\item{model}{evolutionary model to be used. see \code{\link[ape]{dist.dna}} 
for options.}

\item{...}{other arguments passed to \code{\link[ape]{dist.dna}}.}
}
\value{
a list with summaries of the \code{within} and \code{between} strata 
  pairwise distances including Nei's dA (in \code{between}).
}
\description{
Calculate Nei's dA between strata, and distributions of 
  between- and within-strata nucleotide divergence (sequence distance).
}
\examples{
data(dloop.g)

nd <- nucleotideDivergence(dloop.g)
nd$within
nd$between

}
\references{
Nei, M., and S. Kumar (2000) Molecular Evolution and 
  Phylogenetics. Oxford University Press, Oxford. (dA: pp. 256, eqn 12.67)
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
