% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeSamples.R
\name{summarizeSamples}
\alias{summarizeSamples}
\title{Sample Summaries}
\usage{
summarizeSamples(g, sort.by.strata = FALSE)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{sort.by.strata}{logical. Sort data.frame by strata?}
}
\value{
A data.frame with rows for each sample and columns containing:
\describe{
  \item{\code{id}}{The sample id}
  \item{\code{strata}}{The stratum of the sample}
  \item{\code{num.loci.missing.genotypes}}{The number of genotypes missing}
  \item{\code{pct.loci.missing.genotypes}}{The proportion of genotypes missing}
  \item{\code{pct.loci.homozygous}}{The proportion of loci homozygous}
}
}
\description{
Compile standard by-sample summaries.
}
\examples{
data(msats.g)

summarizeSamples(msats.g)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
