% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df2gtypes.R
\name{df2gtypes}
\alias{df2gtypes}
\title{Convert a data.frame to gtypes}
\usage{
df2gtypes(x, ploidy, id.col = 1, strata.col = 2, loc.col = 3,
  sequences = NULL, schemes = NULL, description = NULL, other = NULL)
}
\arguments{
\item{x}{a matrix or data.frame of genetic data.}

\item{ploidy}{number of number of columns in \code{x} storing alleles
at each locus.}

\item{id.col}{column name or number where individual sample ids are stored.
If \code{NULL} then rownames are used. If there are no rownames, then 
samples are labelled with consecutive numbers.}

\item{strata.col}{column name or number where stratification is stored. If 
\code{NULL} then all samples are in one (default) stratum.}

\item{loc.col}{column number of first allele of first locus.}

\item{sequences}{a list, matrix, \code{\link{DNAbin}}, or 
\linkS4class{multidna} object containing sequences.}

\item{schemes}{an optional data.frame of stratification schemes.}

\item{description}{a label for the object (optional).}

\item{other}{a slot to carry other related information - unused in package
analyses (optional).}
}
\value{
a \linkS4class{gtypes} object.
}
\description{
Load allelic data from a data.frame or matrix into a 
  \linkS4class{gtypes} object.
}
\details{
The genetic data in \code{x} starting at \code{loc.col} should be 
formatted such that every consecutive \code{ploidy} columns represent 
alleles of one locus. Locus names are taken from the column names in 
\code{x} and should be formatted with the same root locus name, with 
unique suffixes representing allels (e.g., for Locus1234: Locus1234.1 
and Locus1234.2, or Locus1234_A and Locus1234_B). \cr\cr
If sequences are provided in \code{sequences}, then they should be named 
and match haplotype labels in \code{loc.col} of \code{x}. If multiple 
genes are given as a \linkS4class{multidna}, then they should have the 
same names as column names in \code{x} from \code{loc.col} to the end.
}
\examples{
#--- create a diploid (microsatellite) gtypes object
data(dolph.msats)
ms.g <- df2gtypes(dolph.msats, ploidy = 2, strata.col = NULL, loc.col = 2)
ms.g

#' #--- create a haploid sequence (mtDNA) gtypes object
data(dolph.strata)
data(dolph.haps)

seq.df <- dolph.strata[ c("id", "broad", "dLoop")]
dl.g <- df2gtypes(seq.df, ploidy = 1, sequences = dolph.haps)
dl.g

}
\seealso{
\link{initialize.gtypes}, \link{sequence2gtypes}, 
  \link{as.data.frame.gtypes}, \link{gtypes2genind}, \link{gtypes2loci}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
